/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.b2;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.b2.B2BucketListService;
import ch.cyberduck.core.b2.B2FileidProvider;
import ch.cyberduck.core.b2.B2ObjectListService;
import ch.cyberduck.core.b2.B2Session;
import ch.cyberduck.core.exception.BackgroundException;

public class B2ListService
implements ListService {
    private final B2BucketListService buckets;
    private final B2ObjectListService objects;

    public B2ListService(B2Session session, B2FileidProvider fileid) {
        this.buckets = new B2BucketListService(session);
        this.objects = new B2ObjectListService(session, fileid);
    }

    public AttributedList<Path> list(Path directory, ListProgressListener listener) throws BackgroundException {
        if (directory.isRoot()) {
            return this.buckets.list(directory, listener);
        }
        return this.objects.list(directory, listener);
    }

    public ListService withCache(Cache<Path> cache) {
        this.buckets.withCache(cache);
        this.objects.withCache(cache);
        return this;
    }
}

