/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers;

import com.google.common.base.Function;
import com.google.common.collect.FluentIterable;
import com.spectralogic.ds3client.Ds3Client;
import com.spectralogic.ds3client.helpers.ChecksumFunction;
import com.spectralogic.ds3client.helpers.ChecksumListener;
import com.spectralogic.ds3client.helpers.DataTransferredListener;
import com.spectralogic.ds3client.helpers.Ds3ClientHelpersImpl;
import com.spectralogic.ds3client.helpers.FailureEventListener;
import com.spectralogic.ds3client.helpers.JobRecoveryException;
import com.spectralogic.ds3client.helpers.MetadataAccess;
import com.spectralogic.ds3client.helpers.MetadataReceivedListener;
import com.spectralogic.ds3client.helpers.ObjectCompletedListener;
import com.spectralogic.ds3client.helpers.ObjectStorageSpaceVerificationResult;
import com.spectralogic.ds3client.helpers.WaitingForChunksListener;
import com.spectralogic.ds3client.helpers.options.ReadJobOptions;
import com.spectralogic.ds3client.helpers.options.WriteJobOptions;
import com.spectralogic.ds3client.helpers.pagination.FileSystemKey;
import com.spectralogic.ds3client.helpers.strategy.transferstrategy.TransferStrategy;
import com.spectralogic.ds3client.models.Contents;
import com.spectralogic.ds3client.models.bulk.Ds3Object;
import com.spectralogic.ds3client.utils.Predicate;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.nio.file.Path;
import java.util.Collection;
import java.util.UUID;
import javax.annotation.Nullable;

public abstract class Ds3ClientHelpers {
    public static Ds3ClientHelpers wrap(Ds3Client client) {
        return new Ds3ClientHelpersImpl(client);
    }

    public static Ds3ClientHelpers wrap(Ds3Client client, int retryAfter) {
        return new Ds3ClientHelpersImpl(client, retryAfter);
    }

    public static Ds3ClientHelpers wrap(Ds3Client client, int retryAfter, int objectTransferAttempts) {
        return new Ds3ClientHelpersImpl(client, retryAfter, objectTransferAttempts);
    }

    public abstract Job startWriteJob(String var1, Iterable<Ds3Object> var2) throws IOException;

    public abstract Job startWriteJob(String var1, Iterable<Ds3Object> var2, WriteJobOptions var3) throws IOException;

    public abstract Job startWriteJob(TransferStrategy var1) throws IOException;

    public abstract Job startWriteJobUsingStreamedBehavior(String var1, Iterable<Ds3Object> var2) throws IOException;

    public abstract Job startWriteJobUsingStreamedBehavior(String var1, Iterable<Ds3Object> var2, WriteJobOptions var3) throws IOException;

    public abstract Job startWriteJobUsingRandomAccessBehavior(String var1, Iterable<Ds3Object> var2) throws IOException;

    public abstract Job startWriteJobUsingRandomAccessBehavior(String var1, Iterable<Ds3Object> var2, WriteJobOptions var3) throws IOException;

    public abstract Job startReadJob(String var1, Iterable<Ds3Object> var2) throws IOException;

    public abstract Job startReadJob(String var1, Iterable<Ds3Object> var2, ReadJobOptions var3) throws IOException;

    public abstract Job startReadJob(TransferStrategy var1) throws IOException;

    public abstract Job startReadJobUsingStreamedBehavior(String var1, Iterable<Ds3Object> var2) throws IOException;

    public abstract Job startReadJobUsingStreamedBehavior(String var1, Iterable<Ds3Object> var2, ReadJobOptions var3) throws IOException;

    public abstract Job startReadJobUsingRandomAccessBehavior(String var1, Iterable<Ds3Object> var2) throws IOException;

    public abstract Job startReadJobUsingRandomAccessBehavior(String var1, Iterable<Ds3Object> var2, ReadJobOptions var3) throws IOException;

    public abstract Job startReadAllJob(String var1) throws IOException;

    public abstract Job startReadAllJob(String var1, ReadJobOptions var2) throws IOException;

    public abstract Job startReadAllJobUsingStreamedBehavior(String var1) throws IOException;

    public abstract Job startReadAllJobUsingStreamedBehavior(String var1, ReadJobOptions var2) throws IOException;

    public abstract Job startReadAllJobUsingRandomAccessBehavior(String var1) throws IOException;

    public abstract Job startReadAllJobUsingRandomAccessBehavior(String var1, ReadJobOptions var2) throws IOException;

    public abstract Job recoverWriteJob(UUID var1) throws IOException, JobRecoveryException;

    public abstract Job recoverWriteJobUsingStreamedBehavior(UUID var1) throws IOException, JobRecoveryException;

    public abstract Job recoverWriteJobUsingRandomAccessBehavior(UUID var1) throws IOException, JobRecoveryException;

    public abstract Job recoverReadJob(UUID var1) throws IOException, JobRecoveryException;

    public abstract Job recoverReadJobsingStreamedBehavior(UUID var1) throws IOException, JobRecoveryException;

    public abstract Job recoverReadJobUsingRandomAccessBehavior(UUID var1) throws IOException, JobRecoveryException;

    public abstract void ensureBucketExists(String var1) throws IOException;

    public abstract void ensureBucketExists(String var1, UUID var2) throws IOException;

    public abstract Iterable<Contents> listObjects(String var1) throws IOException;

    public abstract Iterable<Contents> listObjects(String var1, String var2) throws IOException;

    public abstract Iterable<Contents> listObjects(String var1, String var2, String var3) throws IOException;

    public abstract Iterable<Contents> listObjects(String var1, String var2, String var3, int var4);

    public abstract Iterable<Contents> listObjects(String var1, String var2, String var3, int var4, int var5);

    public abstract Iterable<Ds3Object> listObjectsForDirectory(Path var1) throws IOException;

    public abstract Iterable<FileSystemKey> remoteListDirectory(String var1, String var2) throws IOException;

    public abstract Iterable<FileSystemKey> remoteListDirectory(String var1, String var2, String var3) throws IOException;

    public abstract Iterable<FileSystemKey> remoteListDirectory(String var1, String var2, String var3, int var4) throws IOException;

    public abstract Iterable<FileSystemKey> remoteListDirectory(String var1, String var2, String var3, String var4, int var5) throws IOException;

    public abstract void deleteBucket(String var1) throws IOException;

    public abstract Iterable<Ds3Object> addPrefixToDs3ObjectsList(Iterable<Ds3Object> var1, String var2);

    public abstract Iterable<Ds3Object> removePrefixFromDs3ObjectsList(Iterable<Ds3Object> var1, String var2);

    @SafeVarargs
    public final Iterable<Ds3Object> toDs3Iterable(Iterable<Contents> objects, Predicate<Contents> ... filters) {
        FluentIterable fluentIterable = FluentIterable.from(objects).filter(input -> input != null);
        if (filters != null) {
            for (Predicate<Contents> filter : filters) {
                fluentIterable = fluentIterable.filter(input -> filter == null || filter.test((Contents)input));
            }
        }
        return fluentIterable.transform((Function)new Function<Contents, Ds3Object>(){

            @Nullable
            public Ds3Object apply(@Nullable Contents input) {
                return new Ds3Object(input.getKey(), input.getSize());
            }
        });
    }

    public static String stripLeadingPath(String objectName, String prefix) {
        String returnString = objectName;
        if (objectName.startsWith(prefix)) {
            returnString = objectName.substring(prefix.length());
        }
        return returnString;
    }

    public abstract ObjectStorageSpaceVerificationResult objectsFromBucketWillFitInDirectory(String var1, Collection<String> var2, Path var3);

    public abstract void createFolder(String var1, String var2) throws IOException;

    public abstract Ds3Client getClient();

    public static interface Job {
        public UUID getJobId();

        public String getBucketName();

        public void attachDataTransferredListener(DataTransferredListener var1);

        public void removeDataTransferredListener(DataTransferredListener var1);

        public void attachObjectCompletedListener(ObjectCompletedListener var1);

        public void removeObjectCompletedListener(ObjectCompletedListener var1);

        public void attachMetadataReceivedListener(MetadataReceivedListener var1);

        public void removeMetadataReceivedListener(MetadataReceivedListener var1);

        public void attachChecksumListener(ChecksumListener var1);

        public void removeChecksumListener(ChecksumListener var1);

        public void attachWaitingForChunksListener(WaitingForChunksListener var1);

        public void removeWaitingForChunksListener(WaitingForChunksListener var1);

        public void attachFailureEventListener(FailureEventListener var1);

        public void removeFailureEventListener(FailureEventListener var1);

        public Job withMaxParallelRequests(int var1);

        public Job withMetadata(MetadataAccess var1);

        public Job withChecksum(ChecksumFunction var1);

        public void transfer(ObjectChannelBuilder var1) throws IOException;

        public void transfer() throws IOException;
    }

    public static interface ObjectChannelBuilder {
        public SeekableByteChannel buildChannel(String var1) throws IOException;
    }
}

