/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.oauth;

import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostUrlProvider;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.oauth.OAuth2AuthorizationService;
import com.google.api.client.auth.oauth2.Credential;
import com.google.api.client.http.HttpTransport;
import java.io.IOException;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.message.BasicHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.log4j.Logger;

public class OAuth2RequestInterceptor
extends OAuth2AuthorizationService
implements HttpRequestInterceptor {
    private static final Logger log = Logger.getLogger(OAuth2RequestInterceptor.class);
    private OAuth2AuthorizationService.Tokens tokens = OAuth2AuthorizationService.Tokens.EMPTY;

    public OAuth2RequestInterceptor(HttpClient client, Protocol protocol) {
        this(client, protocol.getOAuthTokenUrl(), protocol.getOAuthAuthorizationUrl(), protocol.getOAuthClientId(), protocol.getOAuthClientSecret(), (List<String>)protocol.getOAuthScopes());
    }

    public OAuth2RequestInterceptor(HttpClient client, Host host) {
        this(client, Scheme.isURL((String)host.getProtocol().getOAuthTokenUrl()) ? host.getProtocol().getOAuthTokenUrl() : new HostUrlProvider().withUsername(false).withPath(true).get(host.getProtocol().getScheme(), host.getPort(), null, host.getHostname(), host.getProtocol().getOAuthTokenUrl()), Scheme.isURL((String)host.getProtocol().getOAuthAuthorizationUrl()) ? host.getProtocol().getOAuthAuthorizationUrl() : new HostUrlProvider().withUsername(false).withPath(true).get(host.getProtocol().getScheme(), host.getPort(), null, host.getHostname(), host.getProtocol().getOAuthAuthorizationUrl()), host.getProtocol().getOAuthClientId(), host.getProtocol().getOAuthClientSecret(), (List<String>)host.getProtocol().getOAuthScopes());
    }

    public OAuth2RequestInterceptor(HttpClient client, String tokenServerUrl, String authorizationServerUrl, String clientid, String clientsecret, List<String> scopes) {
        super(client, tokenServerUrl, authorizationServerUrl, clientid, clientsecret, scopes);
    }

    public OAuth2RequestInterceptor(HttpTransport transport, String tokenServerUrl, String authorizationServerUrl, String clientid, String clientsecret, List<String> scopes) {
        super(transport, tokenServerUrl, authorizationServerUrl, clientid, clientsecret, scopes);
    }

    public void setTokens(OAuth2AuthorizationService.Tokens tokens) {
        this.tokens = tokens;
    }

    public OAuth2AuthorizationService.Tokens refresh() throws BackgroundException {
        return super.refresh(this.tokens);
    }

    public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
        if (this.tokens.isExpired()) {
            try {
                this.tokens = this.refresh(this.tokens);
            }
            catch (BackgroundException e) {
                log.warn((Object)String.format("Failure refreshing OAuth 2 tokens. %s", e.getDetail()));
                throw new IOException(e);
            }
        }
        if (StringUtils.isNotBlank((CharSequence)this.tokens.getAccessToken())) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Authorizing service request with OAuth2 access token %s", this.tokens.getAccessToken()));
            }
            request.removeHeaders("Authorization");
            request.addHeader((Header)new BasicHeader("Authorization", String.format("Bearer %s", this.tokens.getAccessToken())));
        }
    }

    @Override
    public OAuth2RequestInterceptor withMethod(Credential.AccessMethod method) {
        super.withMethod(method);
        return this;
    }

    @Override
    public OAuth2RequestInterceptor withRedirectUri(String redirectUri) {
        super.withRedirectUri(redirectUri);
        return this;
    }

    @Override
    public OAuth2RequestInterceptor withParameter(String key, String value) {
        super.withParameter(key, value);
        return this;
    }
}

