/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.helpers;

import com.google.common.collect.ImmutableMap;
import com.google.common.collect.ImmutableMultimap;
import com.spectralogic.ds3client.helpers.AutoCloseableCache;
import com.spectralogic.ds3client.helpers.Ds3ClientHelpers;
import com.spectralogic.ds3client.helpers.JobPartTracker;
import com.spectralogic.ds3client.helpers.ObjectCompletedListener;
import com.spectralogic.ds3client.helpers.channels.RangedSeekableByteChannel;
import com.spectralogic.ds3client.helpers.channels.WindowedChannelFactory;
import com.spectralogic.ds3client.models.Range;
import com.spectralogic.ds3client.models.bulk.BulkObject;
import com.spectralogic.ds3client.models.bulk.Objects;
import java.io.IOException;
import java.nio.channels.SeekableByteChannel;
import java.util.Collection;
import java.util.HashSet;
import java.util.concurrent.atomic.AtomicInteger;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class JobState
implements AutoCloseable {
    private static final Logger LOG = LoggerFactory.getLogger(JobState.class);
    private final AtomicInteger objectsRemaining;
    private final AutoCloseableCache<String, WindowedChannelFactory> channelCache;
    private final JobPartTracker partTracker;

    public JobState(Ds3ClientHelpers.ObjectChannelBuilder channelBuilder, Collection<Objects> filteredChunks, JobPartTracker partTracker, ImmutableMap<String, ImmutableMultimap<BulkObject, Range>> objectRanges) {
        this.objectsRemaining = new AtomicInteger(JobState.getObjectCount(filteredChunks));
        this.channelCache = JobState.buildCache(channelBuilder, objectRanges);
        this.partTracker = partTracker.attachObjectCompletedListener(new ObjectCompletedListenerImpl());
    }

    public boolean hasObjects() {
        return this.objectsRemaining.get() > 0;
    }

    private static int getObjectCount(Collection<Objects> chunks) {
        HashSet<String> result = new HashSet<String>();
        for (Objects chunk : chunks) {
            for (BulkObject bulkObject : chunk.getObjects()) {
                result.add(bulkObject.getName());
            }
        }
        return result.size();
    }

    private static AutoCloseableCache<String, WindowedChannelFactory> buildCache(final Ds3ClientHelpers.ObjectChannelBuilder channelBuilder, final ImmutableMap<String, ImmutableMultimap<BulkObject, Range>> objectRanges) {
        return new AutoCloseableCache<String, WindowedChannelFactory>(new AutoCloseableCache.ValueBuilder<String, WindowedChannelFactory>(){

            @Override
            public WindowedChannelFactory get(String key) {
                try {
                    LOG.debug("Opening channel for : " + key);
                    return new WindowedChannelFactory(RangedSeekableByteChannel.wrap(channelBuilder.buildChannel(key), (ImmutableMultimap<BulkObject, Range>)((ImmutableMultimap)objectRanges.get((Object)key))));
                }
                catch (IOException e) {
                    throw new RuntimeException(e);
                }
            }
        });
    }

    @Override
    public void close() throws Exception {
        this.channelCache.close();
    }

    public JobPartTracker getPartTracker() {
        return this.partTracker;
    }

    public SeekableByteChannel getChannel(String name, long offset, long length) {
        return this.channelCache.get(name).get(offset, length);
    }

    private final class ObjectCompletedListenerImpl
    implements ObjectCompletedListener {
        private ObjectCompletedListenerImpl() {
        }

        @Override
        public void objectCompleted(String name) {
            JobState.this.objectsRemaining.decrementAndGet();
            try {
                LOG.debug("Closing file: " + name);
                JobState.this.channelCache.close(name);
            }
            catch (Exception e) {
                throw new RuntimeException(e);
            }
        }
    }
}

