/*
 * Decompiled with CFR 0.152.
 */
package com.spectralogic.ds3client.commands;

import com.spectralogic.ds3client.BulkCommand;
import com.spectralogic.ds3client.commands.BulkRequest;
import com.spectralogic.ds3client.models.bulk.Ds3Object;
import com.spectralogic.ds3client.models.bulk.Priority;
import com.spectralogic.ds3client.models.bulk.WriteOptimization;
import com.spectralogic.ds3client.serializer.XmlProcessingException;
import java.util.List;

public class BulkPutRequest
extends BulkRequest {
    private static final String MAX_UPLOAD_SIZE_IN_BYTES = "100000000000";
    public static final int MIN_UPLOAD_SIZE_IN_BYTES = 0xA00000;

    public BulkPutRequest(String bucket, List<Ds3Object> objects) throws XmlProcessingException {
        super(bucket, objects);
        this.getQueryParams().put("operation", "start_bulk_put");
    }

    @Override
    public BulkPutRequest withPriority(Priority priority) {
        super.withPriority(priority);
        return this;
    }

    public BulkPutRequest withMaxUploadSize(int size) {
        if (size >= 0xA00000) {
            this.getQueryParams().put("max_upload_size", Long.toString(size));
        } else {
            this.getQueryParams().put("max_upload_size", MAX_UPLOAD_SIZE_IN_BYTES);
        }
        return this;
    }

    @Override
    public BulkPutRequest withWriteOptimization(WriteOptimization writeOptimization) {
        super.withWriteOptimization(writeOptimization);
        return this;
    }

    @Override
    public BulkCommand getCommand() {
        return BulkCommand.PUT;
    }
}

