/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.packinstr;

import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.packinstr.AbstractIRODSPackingInstruction;
import org.irods.jargon.core.packinstr.Tag;

public class ClientServerNegotiationStructNotifyServerOfResult
extends AbstractIRODSPackingInstruction {
    private int status = 0;
    private String result = "";
    public static final String NEG_PI = "CS_NEG_PI";
    public static final int STATUS_FAILURE = 0;
    public static final int STATUS_SUCCESS = 1;
    public static final int API_NBR = 0;
    public static final String CS_NEG_RESULT_KW = "cs_neg_result_kw";

    public String getResult() {
        return this.result;
    }

    public void setResult(String result) {
        this.result = result;
    }

    public static ClientServerNegotiationStructNotifyServerOfResult instanceForFailure() {
        return new ClientServerNegotiationStructNotifyServerOfResult(0, Outcome.CS_NEG_FAILURE.name());
    }

    public static ClientServerNegotiationStructNotifyServerOfResult instance(int status, String result) {
        return new ClientServerNegotiationStructNotifyServerOfResult(status, result);
    }

    private ClientServerNegotiationStructNotifyServerOfResult(int status, String result) {
        if (result == null || result.isEmpty()) {
            throw new IllegalArgumentException("null or empty result");
        }
        this.status = status;
        this.result = result;
        this.setApiNumber(0);
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public String toString() {
        StringBuilder builder = new StringBuilder();
        builder.append("ClientServerNegotiationStruct [status=").append(this.status).append(", ");
        if (this.result != null) {
            builder.append("result=").append(this.result);
        }
        builder.append("]");
        return builder.toString();
    }

    public boolean wasThisASuccess() {
        return this.getStatus() == 1;
    }

    @Override
    public Tag getTagValue() throws JargonException {
        StringBuilder sb = new StringBuilder();
        sb.append(CS_NEG_RESULT_KW);
        sb.append('=');
        sb.append(this.result);
        sb.append(';');
        Tag message = new Tag(NEG_PI, new Tag[]{new Tag("status", this.status), new Tag("result", sb.toString())});
        return message;
    }

    public static enum Outcome {
        CS_NEG_USE_TCP,
        CS_NEG_USE_SSL,
        CS_NEG_FAILURE;

    }
}

