/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.UnixPermission;
import ch.cyberduck.core.features.Vault;

public class CryptoUnixPermission
implements UnixPermission {
    private final Session<?> session;
    private final UnixPermission delegate;
    private final Vault cryptomator;

    public CryptoUnixPermission(Session<?> session, UnixPermission delegate, Vault cryptomator) {
        this.session = session;
        this.delegate = delegate;
        this.cryptomator = cryptomator;
    }

    public void setUnixOwner(Path file, String owner) throws BackgroundException {
        this.delegate.setUnixOwner(this.cryptomator.encrypt(this.session, file), owner);
    }

    public Permission getDefault(Local file) {
        return this.delegate.getDefault(file);
    }

    public void setUnixGroup(Path file, String group) throws BackgroundException {
        this.delegate.setUnixGroup(this.cryptomator.encrypt(this.session, file), group);
    }

    public Permission getUnixPermission(Path file) throws BackgroundException {
        return this.delegate.getUnixPermission(this.cryptomator.encrypt(this.session, file));
    }

    public void setUnixPermission(Path file, Permission permission) throws BackgroundException {
        this.delegate.setUnixPermission(this.cryptomator.encrypt(this.session, file), permission);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoUnixPermission{");
        sb.append("delegate=").append(this.delegate);
        sb.append('}');
        return sb.toString();
    }
}

