/*
 * Decompiled with CFR 0.152.
 */
package synapticloop.b2.response;

import java.util.ArrayList;
import java.util.List;
import org.json.JSONArray;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import synapticloop.b2.exception.B2ApiException;
import synapticloop.b2.response.B2FileInfoResponse;
import synapticloop.b2.response.BaseB2Response;

public class B2ListFilesResponse
extends BaseB2Response {
    private static final Logger LOGGER = LoggerFactory.getLogger(B2ListFilesResponse.class);
    private final List<B2FileInfoResponse> files;
    private final String nextFileName = this.readString("nextFileName");
    private final String nextFileId = this.readString("nextFileId");

    public B2ListFilesResponse(String json) throws B2ApiException {
        super(json);
        JSONArray filesArray = this.readObjects("files");
        this.files = new ArrayList<B2FileInfoResponse>();
        for (int i = 0; i < filesArray.length(); ++i) {
            this.files.add(new B2FileInfoResponse(filesArray.optJSONObject(i)));
        }
        this.warnOnMissedKeys();
    }

    public String getNextFileName() {
        return this.nextFileName;
    }

    public String getNextFileId() {
        return this.nextFileId;
    }

    public List<B2FileInfoResponse> getFiles() {
        return this.files;
    }

    @Override
    protected Logger getLogger() {
        return LOGGER;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("B2ListFilesResponse{");
        sb.append("files=").append(this.files);
        sb.append(", nextFileName='").append(this.nextFileName).append('\'');
        sb.append(", nextFileId='").append(this.nextFileId).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

