/*
 * Decompiled with CFR 0.152.
 */
package ch.iterate.openstack.swift.model;

import java.net.URI;
import java.util.List;
import org.apache.commons.codec.EncoderException;
import org.apache.commons.codec.net.URLCodec;
import org.apache.http.NameValuePair;
import org.apache.http.client.utils.URLEncodedUtils;

public class Region {
    private final String regionId;
    private final URI storageURL;
    private final URI cdnManagementURL;
    private final boolean isDefault;

    public Region(String regionId, URI storageURL, URI cdnManagementURL) {
        this(regionId, storageURL, cdnManagementURL, false);
    }

    public Region(String regionId, URI storageURL, URI cdnManagementURL, boolean isDefault) {
        this.regionId = regionId;
        this.storageURL = storageURL;
        this.cdnManagementURL = cdnManagementURL;
        this.isDefault = isDefault;
    }

    public String getRegionId() {
        return this.regionId;
    }

    public URI getStorageUrl() {
        return this.storageURL;
    }

    public URI getStorageUrl(List<NameValuePair> parameters) {
        return URI.create(String.format("%s?%s", this.getStorageUrl(), URLEncodedUtils.format(parameters, (String)"UTF-8")));
    }

    public URI getStorageUrl(String container) {
        return URI.create(this.getStorageUrl() + "/" + Region.encode(container));
    }

    public URI getStorageUrl(String container, List<NameValuePair> parameters) {
        return URI.create(String.format("%s?%s", this.getStorageUrl(container), URLEncodedUtils.format(parameters, (String)"UTF-8")));
    }

    public URI getStorageUrl(String container, String object) {
        return URI.create(this.getStorageUrl() + "/" + Region.encode(container) + "/" + Region.encode(object, true));
    }

    public URI getStorageUrl(String container, String object, List<NameValuePair> parameters) {
        return URI.create(String.format("%s?%s", this.getStorageUrl(container, object), URLEncodedUtils.format(parameters, (String)"UTF-8")));
    }

    public URI getCDNManagementUrl() {
        return this.cdnManagementURL;
    }

    public URI getCDNManagementUrl(List<NameValuePair> parameters) {
        return URI.create(String.format("%s?%s", this.getCDNManagementUrl(), URLEncodedUtils.format(parameters, (String)"UTF-8")));
    }

    public URI getCDNManagementUrl(String container) {
        return URI.create(this.getCDNManagementUrl() + "/" + Region.encode(container));
    }

    public URI getCDNManagementUrl(String container, String object) {
        return URI.create(this.getCDNManagementUrl() + "/" + Region.encode(container) + "/" + Region.encode(object, true));
    }

    public boolean isDefault() {
        return this.isDefault;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Region that = (Region)o;
        return !(this.regionId != null ? !this.regionId.equals(that.regionId) : that.regionId != null);
    }

    public int hashCode() {
        return this.regionId != null ? this.regionId.hashCode() : 0;
    }

    private static String encode(String name) {
        return Region.encode(name, false);
    }

    private static String encode(String object, boolean preserveslashes) {
        URLCodec codec = new URLCodec();
        try {
            String encoded = codec.encode(object).replaceAll("\\+", "%20");
            if (preserveslashes) {
                return encoded.replaceAll("%2F", "/");
            }
            return encoded;
        }
        catch (EncoderException ee) {
            return object;
        }
    }
}

