/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.vault.VaultRegistry;

public class VaultRegistrySearchFeature
implements Search {
    private final Session<?> session;
    private final Search proxy;
    private final VaultRegistry registry;
    private Cache<Path> cache;

    public VaultRegistrySearchFeature(Session<?> session, Search proxy, VaultRegistry registry) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public AttributedList<Path> search(Path workdir, Filter<Path> regex, ListProgressListener listener) throws BackgroundException {
        return this.registry.find(this.session, workdir).getFeature(this.session, Search.class, this.proxy).withCache(this.cache).search(workdir, regex, listener);
    }

    @Override
    public boolean isRecursive() {
        return this.proxy.isRecursive();
    }

    @Override
    public Search withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistrySearchFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

