/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Headers;
import ch.cyberduck.core.vault.VaultRegistry;
import java.util.Map;

public class VaultRegistryHeadersFeature
implements Headers {
    private final Session<?> session;
    private final Headers proxy;
    private final VaultRegistry registry;

    public VaultRegistryHeadersFeature(Session<?> session, Headers proxy, VaultRegistry registry) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public Map<String, String> getDefault(Local local) {
        return this.proxy.getDefault(local);
    }

    @Override
    public Map<String, String> getMetadata(Path file) throws BackgroundException {
        return this.registry.find(this.session, file).getFeature(this.session, Headers.class, this.proxy).getMetadata(file);
    }

    @Override
    public void setMetadata(Path file, Map<String, String> metadata) throws BackgroundException {
        this.registry.find(this.session, file).getFeature(this.session, Headers.class, this.proxy).setMetadata(file, metadata);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryHeadersFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

