/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.LocalAttributes;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.NullFilter;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.Serializable;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.exception.LocalAccessDeniedException;
import ch.cyberduck.core.exception.LocalNotfoundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.io.LocalRepeatableFileInputStream;
import ch.cyberduck.core.local.DefaultLocalDirectoryFeature;
import ch.cyberduck.core.local.TildeExpander;
import ch.cyberduck.core.local.WorkdirPrefixer;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.serializer.Serializer;
import ch.cyberduck.core.unicode.NFCNormalizer;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.file.AtomicMoveNotSupportedException;
import java.nio.file.DirectoryStream;
import java.nio.file.FileAlreadyExistsException;
import java.nio.file.Files;
import java.nio.file.InvalidPathException;
import java.nio.file.LinkOption;
import java.nio.file.NoSuchFileException;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.nio.file.StandardCopyOption;
import java.util.EnumSet;
import java.util.Objects;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.CharUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class Local
extends AbstractPath
implements Referenceable,
Serializable {
    private static final Logger log = Logger.getLogger(Local.class);
    private String path;
    private final LocalAttributes attributes;

    public Local(String parent, String name) {
        this(parent, name, PreferencesFactory.get().getProperty("local.delimiter"));
    }

    public Local(String parent, String name, String delimiter) {
        this(parent.endsWith(delimiter) ? String.format("%s%s", parent, name) : String.format("%s%c%s", parent, Character.valueOf(CharUtils.toChar((String)delimiter)), name));
    }

    public Local(Local parent, String name) {
        this(parent, name, PreferencesFactory.get().getProperty("local.delimiter"));
    }

    public Local(Local parent, String name, String delimiter) {
        this(parent.isRoot() ? String.format("%s%s", parent.getAbsolute(), name) : String.format("%s%c%s", parent.getAbsolute(), Character.valueOf(CharUtils.toChar((String)delimiter)), name));
    }

    public Local(String name) {
        String path = name;
        if (PreferencesFactory.get().getBoolean("local.normalize.unicode")) {
            path = new NFCNormalizer().normalize(path).toString();
        }
        if (PreferencesFactory.get().getBoolean("local.normalize.tilde")) {
            path = new TildeExpander().expand(path);
        }
        if (PreferencesFactory.get().getBoolean("local.normalize.prefix")) {
            path = new WorkdirPrefixer().normalize(path);
        }
        try {
            this.path = Paths.get(path, new String[0]).toString();
        }
        catch (InvalidPathException e) {
            log.error((Object)String.format("The name %s is not a valid path for the filesystem", path), (Throwable)e);
            this.path = path;
        }
        this.attributes = new LocalAttributes(path);
    }

    @Override
    public <T> T serialize(Serializer dict) {
        dict.setStringForKey(this.path, "Path");
        return dict.getSerialized();
    }

    @Override
    public EnumSet<AbstractPath.Type> getType() {
        EnumSet<AbstractPath.Type> set = EnumSet.noneOf(AbstractPath.Type.class);
        if (this.isDirectory()) {
            set.add(AbstractPath.Type.directory);
            if (this.isVolume()) {
                set.add(AbstractPath.Type.volume);
            }
        } else {
            set.add(AbstractPath.Type.file);
        }
        if (this.isSymbolicLink()) {
            set.add(AbstractPath.Type.symboliclink);
        }
        return set;
    }

    public boolean isVolume() {
        return null == Paths.get(this.path, new String[0]).getParent();
    }

    public boolean isDirectory() {
        return Files.isDirectory(Paths.get(this.path, new String[0]), new LinkOption[0]);
    }

    public boolean isFile() {
        return Files.isRegularFile(Paths.get(this.path, new String[0]), new LinkOption[0]);
    }

    public boolean isSymbolicLink() {
        return Files.isSymbolicLink(Paths.get(this.path, new String[0]));
    }

    public Local getSymlinkTarget() throws NotfoundException, LocalAccessDeniedException {
        try {
            Path target = Files.readSymbolicLink(Paths.get(this.path, new String[0]));
            if (target.isAbsolute()) {
                return LocalFactory.get(target.toString());
            }
            return LocalFactory.get(this.getParent(), target.toString());
        }
        catch (IOException | InvalidPathException e) {
            throw new LocalNotfoundException(String.format("Resolving symlink target for %s failed", this.path), e);
        }
    }

    public LocalAttributes attributes() {
        return this.attributes;
    }

    @Override
    public char getDelimiter() {
        return CharUtils.toChar((String)PreferencesFactory.get().getProperty("local.delimiter"));
    }

    public void mkdir() throws AccessDeniedException {
        new DefaultLocalDirectoryFeature().mkdir(this);
    }

    public void delete() throws AccessDeniedException, NotfoundException {
        try {
            Files.delete(Paths.get(this.path, new String[0]));
        }
        catch (NoSuchFileException e) {
            throw new LocalNotfoundException(String.format("Delete %s failed", this.path), e);
        }
        catch (IOException e) {
            throw new LocalAccessDeniedException(String.format("Delete %s failed", this.path), e);
        }
    }

    public AttributedList<Local> list(final Filter<String> filter) throws AccessDeniedException {
        AttributedList<Local> children = new AttributedList<Local>();
        try (DirectoryStream<Path> stream = Files.newDirectoryStream(Paths.get(this.path, new String[0]), (DirectoryStream.Filter<? super Path>)new DirectoryStream.Filter<Path>(){

            @Override
            public boolean accept(Path entry) throws IOException {
                if (null == entry.getFileName()) {
                    return false;
                }
                return filter.accept(entry.getFileName().toString());
            }
        });){
            for (Path entry : stream) {
                children.add(LocalFactory.get(entry.toString()));
            }
        }
        catch (IOException e) {
            throw new LocalAccessDeniedException(String.format("Error listing files in directory %s", this.path), e);
        }
        return children;
    }

    public AttributedList<Local> list() throws AccessDeniedException {
        return this.list(new NullFilter<String>());
    }

    @Override
    public String getAbsolute() {
        return this.path;
    }

    public String getBookmark() {
        return this.path;
    }

    public void setBookmark(String data) {
    }

    public Local withBookmark(String data) {
        this.setBookmark(data);
        return this;
    }

    public String getAbbreviatedPath() {
        return new TildeExpander().abbreviate(this.path);
    }

    public String getDisplayName() {
        return this.getName();
    }

    @Override
    public String getName() {
        return FilenameUtils.getName((String)this.path);
    }

    public Local getVolume() {
        return LocalFactory.get(String.valueOf(this.getDelimiter()));
    }

    public Local getParent() {
        if (this.isVolume()) {
            return this;
        }
        return LocalFactory.get(Paths.get(this.path, new String[0]).getParent().toString());
    }

    public boolean exists() {
        return Files.exists(Paths.get(this.path, new String[0]), LinkOption.NOFOLLOW_LINKS);
    }

    public void rename(Local renamed) throws AccessDeniedException {
        try {
            try {
                Files.move(Paths.get(this.path, new String[0]), Paths.get(renamed.getAbsolute(), new String[0]), StandardCopyOption.REPLACE_EXISTING, StandardCopyOption.ATOMIC_MOVE);
            }
            catch (AtomicMoveNotSupportedException | FileAlreadyExistsException e) {
                Files.move(Paths.get(this.path, new String[0]), Paths.get(renamed.getAbsolute(), new String[0]), StandardCopyOption.REPLACE_EXISTING);
            }
        }
        catch (IOException e) {
            throw new LocalAccessDeniedException(String.format("Rename to %s failed for %s", renamed, this), e);
        }
        this.path = renamed.getAbsolute();
    }

    public void copy(Local copy) throws AccessDeniedException {
        this.copy(copy, new CopyOptions());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void copy(Local copy, CopyOptions options) throws AccessDeniedException {
        if (copy.equals(this)) {
            log.warn((Object)String.format("%s and %s are identical. Not copied.", this.getName(), copy.getName()));
            return;
        }
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Copy to %s with options %s", copy, options));
        }
        InputStream in = null;
        OutputStream out = null;
        try {
            in = this.getInputStream();
            out = copy.getOutputStream(options.append);
            IOUtils.copy((InputStream)in, (OutputStream)out);
        }
        catch (IOException e) {
            try {
                throw new LocalAccessDeniedException(e.getMessage(), e);
            }
            catch (Throwable throwable) {
                IOUtils.closeQuietly((InputStream)in);
                IOUtils.closeQuietly(out);
                throw throwable;
            }
        }
        IOUtils.closeQuietly((InputStream)in);
        IOUtils.closeQuietly((OutputStream)out);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof Local)) {
            return false;
        }
        Local local = (Local)o;
        return !(this.path != null ? !this.path.equalsIgnoreCase(local.path) : local.path != null);
    }

    public int hashCode() {
        return this.path != null ? StringUtils.lowerCase((String)this.path).hashCode() : 0;
    }

    public String toURL() {
        return String.format("file:%s", this.path);
    }

    public InputStream getInputStream() throws AccessDeniedException {
        try {
            return new LocalRepeatableFileInputStream(new File(this.path));
        }
        catch (FileNotFoundException e) {
            throw new LocalAccessDeniedException(e.getMessage(), e);
        }
    }

    public OutputStream getOutputStream(boolean append) throws AccessDeniedException {
        try {
            return new FileOutputStream(new File(this.path), append);
        }
        catch (FileNotFoundException e) {
            throw new LocalAccessDeniedException(e.getMessage(), e);
        }
    }

    public Object lock(boolean interactive) throws AccessDeniedException {
        return null;
    }

    public void release(Object lock) {
    }

    public boolean isChild(Local directory) {
        if (this.isRoot()) {
            return false;
        }
        if (Objects.equals(this.parent(this.getAbsolute()), this.parent(directory.getAbsolute()))) {
            return false;
        }
        String prefix = FilenameUtils.getPrefix((String)this.getAbsolute());
        String parent = this.getAbsolute();
        while (!parent.equals(prefix)) {
            parent = this.parent(parent);
            if (!directory.getAbsolute().equals(parent)) continue;
            return true;
        }
        return false;
    }

    private String parent(String absolute) {
        int cut;
        String prefix = FilenameUtils.getPrefix((String)absolute);
        if (absolute.equals(prefix)) {
            return null;
        }
        int index = absolute.length() - 1;
        if (absolute.charAt(index) == this.getDelimiter() && index > 0) {
            --index;
        }
        if ((cut = absolute.lastIndexOf(this.getDelimiter(), index)) > FilenameUtils.getPrefixLength((String)absolute)) {
            return absolute.substring(0, cut);
        }
        return String.valueOf(prefix);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("Local{");
        sb.append("path='").append(this.path).append('\'');
        sb.append('}');
        return sb.toString();
    }

    public static final class CopyOptions {
        public boolean append;

        public CopyOptions append(boolean append) {
            this.append = append;
            return this;
        }

        public String toString() {
            StringBuilder sb = new StringBuilder("CopyOptions{");
            sb.append("append=").append(this.append);
            sb.append('}');
            return sb.toString();
        }
    }
}

