/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.config;

import com.joyent.manta.client.crypto.AesCtrCipherDetails;
import com.joyent.manta.client.crypto.SupportedCipherDetails;
import com.joyent.manta.config.ConfigContext;
import com.joyent.manta.config.EncryptionAuthenticationMode;
import java.io.File;

public class DefaultsConfigContext
implements ConfigContext {
    public static final String DEFAULT_MANTA_URL = "https://us-east.manta.joyent.com:443";
    public static final int DEFAULT_HTTP_TIMEOUT = 20000;
    public static final int DEFAULT_HTTP_RETRIES = 3;
    public static final int DEFAULT_MAX_CONNS = 24;
    public static final String MANTA_KEY_PATH;
    public static final int DEFAULT_HTTP_BUFFER_SIZE = 4096;
    public static final String DEFAULT_HTTPS_PROTOCOLS = "TLSv1.2";
    public static final boolean DEFAULT_VERIFY_UPLOADS = true;
    public static final boolean DEFAULT_PERMIT_UNENCRYPTED_DOWNLOADS = false;
    public static final SupportedCipherDetails DEFAULT_CIPHER;
    public static final String DEFAULT_HTTPS_CIPHERS = "TLS_ECDHE_RSA_WITH_AES_128_CBC_SHA,TLS_RSA_WITH_AES_128_GCM_SHA256,TLS_RSA_WITH_AES_256_CBC_SHA256,TLS_RSA_WITH_AES_128_CBC_SHA256";
    public static final boolean DEFAULT_NO_AUTH = false;
    public static final boolean DEFAULT_DISABLE_NATIVE_SIGNATURES = false;
    public static final int DEFAULT_TCP_SOCKET_TIMEOUT = 10000;
    public static final int DEFAULT_CONNECTION_REQUEST_TIMEOUT = 1000;
    public static final Integer DEFAULT_EXPECT_CONTINUE_TIMEOUT;
    public static final int DEFAULT_UPLOAD_BUFFER_SIZE = 16384;

    @Override
    public String getMantaURL() {
        return DEFAULT_MANTA_URL;
    }

    @Override
    public String getMantaUser() {
        return null;
    }

    @Override
    public String getMantaKeyId() {
        return null;
    }

    @Override
    public String getMantaKeyPath() {
        return MANTA_KEY_PATH;
    }

    @Override
    public String getPrivateKeyContent() {
        return null;
    }

    @Override
    public String getPassword() {
        return null;
    }

    @Override
    public Integer getTimeout() {
        return 20000;
    }

    @Override
    public Integer getRetries() {
        return 3;
    }

    @Override
    public Integer getMaximumConnections() {
        return 24;
    }

    @Override
    public Integer getHttpBufferSize() {
        return 4096;
    }

    @Override
    public String getHttpsProtocols() {
        return DEFAULT_HTTPS_PROTOCOLS;
    }

    @Override
    public String getHttpsCipherSuites() {
        return DEFAULT_HTTPS_CIPHERS;
    }

    @Override
    public Boolean noAuth() {
        return false;
    }

    @Override
    public Boolean disableNativeSignatures() {
        return false;
    }

    @Override
    public Integer getTcpSocketTimeout() {
        return 10000;
    }

    @Override
    public Integer getConnectionRequestTimeout() {
        return 1000;
    }

    @Override
    public Integer getExpectContinueTimeout() {
        return DEFAULT_EXPECT_CONTINUE_TIMEOUT;
    }

    @Override
    public Boolean verifyUploads() {
        return true;
    }

    @Override
    public Integer getUploadBufferSize() {
        return 16384;
    }

    @Override
    public Integer getSkipDirectoryDepth() {
        return null;
    }

    @Override
    public Boolean isClientEncryptionEnabled() {
        return false;
    }

    @Override
    public String getEncryptionKeyId() {
        return null;
    }

    @Override
    public String getEncryptionAlgorithm() {
        return DEFAULT_CIPHER.getCipherAlgorithm();
    }

    @Override
    public Boolean permitUnencryptedDownloads() {
        return false;
    }

    @Override
    public EncryptionAuthenticationMode getEncryptionAuthenticationMode() {
        return EncryptionAuthenticationMode.DEFAULT_MODE;
    }

    @Override
    public String getEncryptionPrivateKeyPath() {
        return null;
    }

    @Override
    public byte[] getEncryptionPrivateKeyBytes() {
        return null;
    }

    public String toString() {
        return ConfigContext.toString(this);
    }

    static {
        DEFAULT_CIPHER = AesCtrCipherDetails.INSTANCE_128_BIT;
        DEFAULT_EXPECT_CONTINUE_TIMEOUT = null;
        String defaultKeyPath = String.format("%s/.ssh/id_rsa", System.getProperty("user.home"));
        File privateKeyFile = new File(defaultKeyPath);
        MANTA_KEY_PATH = privateKeyFile.exists() && privateKeyFile.canRead() ? defaultKeyPath : null;
    }
}

