/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import ch.cyberduck.core.ConnectionCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.dav.DAVExceptionMappingService;
import ch.cyberduck.core.dav.DAVPathEncoder;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.http.HttpExceptionMappingService;
import ch.cyberduck.core.http.HttpRange;
import ch.cyberduck.core.transfer.TransferStatus;
import com.github.sardine.impl.SardineException;
import com.github.sardine.impl.io.ContentLengthInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Map;
import org.apache.http.message.BasicHeader;
import org.apache.log4j.Logger;

public class DAVReadFeature
implements Read {
    private static final Logger log = Logger.getLogger(DAVReadFeature.class);
    private final DAVSession session;

    public DAVReadFeature(DAVSession session) {
        this.session = session;
    }

    public InputStream read(Path file, TransferStatus status, ConnectionCallback callback) throws BackgroundException {
        ArrayList<BasicHeader> headers = new ArrayList<BasicHeader>();
        if (status.isAppend()) {
            HttpRange range = HttpRange.withStatus((TransferStatus)status);
            String header = -1L == range.getEnd() ? String.format("bytes=%d-", range.getStart()) : String.format("bytes=%d-%d", range.getStart(), range.getEnd());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Add range header %s for file %s", header, file));
            }
            headers.add(new BasicHeader("Range", header));
            headers.add(new BasicHeader("Accept-Encoding", "identity"));
        }
        try {
            StringBuilder resource = new StringBuilder(new DAVPathEncoder().encode(file));
            if (!status.getParameters().isEmpty()) {
                resource.append("?");
            }
            for (Map.Entry entry : status.getParameters().entrySet()) {
                if (!resource.toString().endsWith("?")) {
                    resource.append("&");
                }
                resource.append(URIEncoder.encode((String)((String)entry.getKey()))).append("=").append(URIEncoder.encode((String)((String)entry.getValue())));
            }
            ContentLengthInputStream stream = ((DAVClient)((Object)this.session.getClient())).get(resource.toString(), headers);
            if (status.isAppend() && stream.getCode() == 200) {
                log.warn((Object)String.format("Range header not supported. Skipping %d bytes in file %s.", status.getOffset(), file));
                stream.skip(status.getOffset());
            }
            return stream;
        }
        catch (SardineException e) {
            throw new DAVExceptionMappingService().map("Download {0} failed", e, file);
        }
        catch (IOException e) {
            throw new HttpExceptionMappingService().map("Download {0} failed", (Throwable)e, file);
        }
    }

    public boolean offset(Path file) {
        return true;
    }
}

