/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.sharing;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.sharing.AccessLevel;
import com.dropbox.core.v2.sharing.InviteeInfo;
import com.dropbox.core.v2.sharing.MemberPermission;
import com.dropbox.core.v2.sharing.MembershipInfo;
import com.dropbox.core.v2.sharing.UserInfo;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;

public class InviteeMembershipInfo
extends MembershipInfo {
    protected final InviteeInfo invitee;
    protected final UserInfo user;

    public InviteeMembershipInfo(AccessLevel accessType, InviteeInfo invitee, List<MemberPermission> permissions, String initials, boolean isInherited, UserInfo user) {
        super(accessType, permissions, initials, isInherited);
        if (invitee == null) {
            throw new IllegalArgumentException("Required value for 'invitee' is null");
        }
        this.invitee = invitee;
        this.user = user;
    }

    public InviteeMembershipInfo(AccessLevel accessType, InviteeInfo invitee) {
        this(accessType, invitee, null, null, false, null);
    }

    @Override
    public AccessLevel getAccessType() {
        return this.accessType;
    }

    public InviteeInfo getInvitee() {
        return this.invitee;
    }

    @Override
    public List<MemberPermission> getPermissions() {
        return this.permissions;
    }

    @Override
    public String getInitials() {
        return this.initials;
    }

    @Override
    public boolean getIsInherited() {
        return this.isInherited;
    }

    public UserInfo getUser() {
        return this.user;
    }

    public static Builder newBuilder(AccessLevel accessType, InviteeInfo invitee) {
        return new Builder(accessType, invitee);
    }

    @Override
    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.invitee, this.user});
        hash = 31 * super.hashCode() + hash;
        return hash;
    }

    @Override
    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            InviteeMembershipInfo other = (InviteeMembershipInfo)obj;
            return !(this.accessType != other.accessType && !this.accessType.equals((Object)other.accessType) || this.invitee != other.invitee && !this.invitee.equals(other.invitee) || this.permissions != other.permissions && (this.permissions == null || !this.permissions.equals(other.permissions)) || this.initials != other.initials && (this.initials == null || !this.initials.equals(other.initials)) || this.isInherited != other.isInherited || this.user != other.user && (this.user == null || !this.user.equals(other.user)));
        }
        return false;
    }

    @Override
    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    @Override
    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<InviteeMembershipInfo> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(InviteeMembershipInfo value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("access_type");
            AccessLevel.Serializer.INSTANCE.serialize(value.accessType, g);
            g.writeFieldName("invitee");
            InviteeInfo.Serializer.INSTANCE.serialize(value.invitee, g);
            if (value.permissions != null) {
                g.writeFieldName("permissions");
                StoneSerializers.nullable(StoneSerializers.list(MemberPermission.Serializer.INSTANCE)).serialize((List<MemberPermission>)value.permissions, g);
            }
            if (value.initials != null) {
                g.writeFieldName("initials");
                StoneSerializers.nullable(StoneSerializers.string()).serialize(value.initials, g);
            }
            g.writeFieldName("is_inherited");
            StoneSerializers.boolean_().serialize((Boolean)value.isInherited, g);
            if (value.user != null) {
                g.writeFieldName("user");
                StoneSerializers.nullableStruct(UserInfo.Serializer.INSTANCE).serialize(value.user, g);
            }
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public InviteeMembershipInfo deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            UserInfo f_user;
            Boolean f_isInherited;
            String f_initials;
            List<MemberPermission> f_permissions;
            InviteeInfo f_invitee;
            AccessLevel f_accessType;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_accessType = null;
                f_invitee = null;
                f_permissions = null;
                f_initials = null;
                f_isInherited = false;
                f_user = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("access_type".equals(field)) {
                        f_accessType = AccessLevel.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("invitee".equals(field)) {
                        f_invitee = InviteeInfo.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("permissions".equals(field)) {
                        f_permissions = StoneSerializers.nullable(StoneSerializers.list(MemberPermission.Serializer.INSTANCE)).deserialize(p);
                        continue;
                    }
                    if ("initials".equals(field)) {
                        f_initials = StoneSerializers.nullable(StoneSerializers.string()).deserialize(p);
                        continue;
                    }
                    if ("is_inherited".equals(field)) {
                        f_isInherited = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    if ("user".equals(field)) {
                        f_user = StoneSerializers.nullableStruct(UserInfo.Serializer.INSTANCE).deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_accessType == null) {
                    throw new JsonParseException(p, "Required field \"access_type\" missing.");
                }
                if (f_invitee == null) {
                    throw new JsonParseException(p, "Required field \"invitee\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            InviteeMembershipInfo value = new InviteeMembershipInfo(f_accessType, f_invitee, f_permissions, f_initials, f_isInherited, f_user);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }

    public static class Builder
    extends MembershipInfo.Builder {
        protected final InviteeInfo invitee;
        protected UserInfo user;

        protected Builder(AccessLevel accessType, InviteeInfo invitee) {
            super(accessType);
            if (invitee == null) {
                throw new IllegalArgumentException("Required value for 'invitee' is null");
            }
            this.invitee = invitee;
            this.user = null;
        }

        public Builder withUser(UserInfo user) {
            this.user = user;
            return this;
        }

        @Override
        public Builder withPermissions(List<MemberPermission> permissions) {
            super.withPermissions(permissions);
            return this;
        }

        @Override
        public Builder withInitials(String initials) {
            super.withInitials(initials);
            return this;
        }

        @Override
        public Builder withIsInherited(Boolean isInherited) {
            super.withIsInherited(isInherited);
            return this;
        }

        @Override
        public InviteeMembershipInfo build() {
            return new InviteeMembershipInfo(this.accessType, this.invitee, this.permissions, this.initials, this.isInherited, this.user);
        }
    }
}

