/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.UserInfo;
import com.fasterxml.jackson.annotation.JsonProperty;
import io.swagger.annotations.ApiModelProperty;
import java.util.Objects;
import org.joda.time.DateTime;

public class UploadShare {
    @JsonProperty(value="id")
    private Long id = null;
    @JsonProperty(value="targetId")
    private Long targetId = null;
    @JsonProperty(value="name")
    private String name = null;
    @JsonProperty(value="isProtected")
    private Boolean isProtected = null;
    @JsonProperty(value="accessKey")
    private String accessKey = null;
    @JsonProperty(value="expireAt")
    private DateTime expireAt = null;
    @JsonProperty(value="notifyCreator")
    private Boolean notifyCreator = null;
    @JsonProperty(value="createdAt")
    private DateTime createdAt = null;
    @JsonProperty(value="createdBy")
    private UserInfo createdBy = null;
    @JsonProperty(value="targetPath")
    private String targetPath = null;
    @JsonProperty(value="isEncrypted")
    private Boolean isEncrypted = null;
    @JsonProperty(value="notes")
    private String notes = null;
    @JsonProperty(value="filesExpiryPeriod")
    private Integer filesExpiryPeriod = null;
    @JsonProperty(value="recipients")
    private String recipients = null;
    @JsonProperty(value="smsRecipients")
    private String smsRecipients = null;
    @JsonProperty(value="cntFiles")
    private Integer cntFiles = null;
    @JsonProperty(value="cntUploads")
    private Integer cntUploads = null;
    @JsonProperty(value="showUploadedFiles")
    private Boolean showUploadedFiles = null;
    @JsonProperty(value="dataUrl")
    private String dataUrl = null;
    @JsonProperty(value="maxSlots")
    private Integer maxSlots = null;
    @JsonProperty(value="maxSize")
    private Long maxSize = null;

    public UploadShare id(Long id) {
        this.id = id;
        return this;
    }

    @ApiModelProperty(required=true, value="Share ID")
    public Long getId() {
        return this.id;
    }

    public void setId(Long id) {
        this.id = id;
    }

    public UploadShare targetId(Long targetId) {
        this.targetId = targetId;
        return this;
    }

    @ApiModelProperty(required=true, value="Target room or folder ID")
    public Long getTargetId() {
        return this.targetId;
    }

    public void setTargetId(Long targetId) {
        this.targetId = targetId;
    }

    public UploadShare name(String name) {
        this.name = name;
        return this;
    }

    @ApiModelProperty(required=true, value="Alias name")
    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name;
    }

    public UploadShare isProtected(Boolean isProtected) {
        this.isProtected = isProtected;
        return this;
    }

    @ApiModelProperty(example="false", required=true, value="Is share protected by password")
    public Boolean getIsProtected() {
        return this.isProtected;
    }

    public void setIsProtected(Boolean isProtected) {
        this.isProtected = isProtected;
    }

    public UploadShare accessKey(String accessKey) {
        this.accessKey = accessKey;
        return this;
    }

    @ApiModelProperty(required=true, value="Share access key to generate secure link")
    public String getAccessKey() {
        return this.accessKey;
    }

    public void setAccessKey(String accessKey) {
        this.accessKey = accessKey;
    }

    public UploadShare expireAt(DateTime expireAt) {
        this.expireAt = expireAt;
        return this;
    }

    @ApiModelProperty(example="2018-01-01T00:00:00", required=true, value="Expiration date")
    public DateTime getExpireAt() {
        return this.expireAt;
    }

    public void setExpireAt(DateTime expireAt) {
        this.expireAt = expireAt;
    }

    public UploadShare notifyCreator(Boolean notifyCreator) {
        this.notifyCreator = notifyCreator;
        return this;
    }

    @ApiModelProperty(example="false", required=true, value="Notify creator on every upload. (default: false)")
    public Boolean getNotifyCreator() {
        return this.notifyCreator;
    }

    public void setNotifyCreator(Boolean notifyCreator) {
        this.notifyCreator = notifyCreator;
    }

    public UploadShare createdAt(DateTime createdAt) {
        this.createdAt = createdAt;
        return this;
    }

    @ApiModelProperty(example="2018-01-01T00:00:00", required=true, value="Creation date")
    public DateTime getCreatedAt() {
        return this.createdAt;
    }

    public void setCreatedAt(DateTime createdAt) {
        this.createdAt = createdAt;
    }

    public UploadShare createdBy(UserInfo createdBy) {
        this.createdBy = createdBy;
        return this;
    }

    @ApiModelProperty(required=true, value="Created by user info")
    public UserInfo getCreatedBy() {
        return this.createdBy;
    }

    public void setCreatedBy(UserInfo createdBy) {
        this.createdBy = createdBy;
    }

    public UploadShare targetPath(String targetPath) {
        this.targetPath = targetPath;
        return this;
    }

    @ApiModelProperty(value="Path to shared upload node")
    public String getTargetPath() {
        return this.targetPath;
    }

    public void setTargetPath(String targetPath) {
        this.targetPath = targetPath;
    }

    public UploadShare isEncrypted(Boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
        return this;
    }

    @ApiModelProperty(example="false", value="Encryption state")
    public Boolean getIsEncrypted() {
        return this.isEncrypted;
    }

    public void setIsEncrypted(Boolean isEncrypted) {
        this.isEncrypted = isEncrypted;
    }

    public UploadShare notes(String notes) {
        this.notes = notes;
        return this;
    }

    @ApiModelProperty(value="User notes (limited to 255 characters)")
    public String getNotes() {
        return this.notes;
    }

    public void setNotes(String notes) {
        this.notes = notes;
    }

    public UploadShare filesExpiryPeriod(Integer filesExpiryPeriod) {
        this.filesExpiryPeriod = filesExpiryPeriod;
        return this;
    }

    @ApiModelProperty(value="Number of days after which uploaded files expire")
    public Integer getFilesExpiryPeriod() {
        return this.filesExpiryPeriod;
    }

    public void setFilesExpiryPeriod(Integer filesExpiryPeriod) {
        this.filesExpiryPeriod = filesExpiryPeriod;
    }

    public UploadShare recipients(String recipients) {
        this.recipients = recipients;
        return this;
    }

    @ApiModelProperty(value="CSV string of recipient emails")
    public String getRecipients() {
        return this.recipients;
    }

    public void setRecipients(String recipients) {
        this.recipients = recipients;
    }

    public UploadShare smsRecipients(String smsRecipients) {
        this.smsRecipients = smsRecipients;
        return this;
    }

    @ApiModelProperty(value="CSV string of recipient MSISDNs")
    public String getSmsRecipients() {
        return this.smsRecipients;
    }

    public void setSmsRecipients(String smsRecipients) {
        this.smsRecipients = smsRecipients;
    }

    public UploadShare cntFiles(Integer cntFiles) {
        this.cntFiles = cntFiles;
        return this;
    }

    @ApiModelProperty(value="Total amount of existing files uploaded with this share.")
    public Integer getCntFiles() {
        return this.cntFiles;
    }

    public void setCntFiles(Integer cntFiles) {
        this.cntFiles = cntFiles;
    }

    public UploadShare cntUploads(Integer cntUploads) {
        this.cntUploads = cntUploads;
        return this;
    }

    @ApiModelProperty(value="Total amount of uploads conducted with this share.")
    public Integer getCntUploads() {
        return this.cntUploads;
    }

    public void setCntUploads(Integer cntUploads) {
        this.cntUploads = cntUploads;
    }

    public UploadShare showUploadedFiles(Boolean showUploadedFiles) {
        this.showUploadedFiles = showUploadedFiles;
        return this;
    }

    @ApiModelProperty(example="false", value="Allow display of already uploaded files (default: false)")
    public Boolean getShowUploadedFiles() {
        return this.showUploadedFiles;
    }

    public void setShowUploadedFiles(Boolean showUploadedFiles) {
        this.showUploadedFiles = showUploadedFiles;
    }

    public UploadShare dataUrl(String dataUrl) {
        this.dataUrl = dataUrl;
        return this;
    }

    @ApiModelProperty(example="https://www.random-url.com", value="Upload Share URL")
    public String getDataUrl() {
        return this.dataUrl;
    }

    public void setDataUrl(String dataUrl) {
        this.dataUrl = dataUrl;
    }

    public UploadShare maxSlots(Integer maxSlots) {
        this.maxSlots = maxSlots;
        return this;
    }

    @ApiModelProperty(value="Maximal amount of files to upload")
    public Integer getMaxSlots() {
        return this.maxSlots;
    }

    public void setMaxSlots(Integer maxSlots) {
        this.maxSlots = maxSlots;
    }

    public UploadShare maxSize(Long maxSize) {
        this.maxSize = maxSize;
        return this;
    }

    @ApiModelProperty(value="Maximal total size of uploaded files (in bytes)")
    public Long getMaxSize() {
        return this.maxSize;
    }

    public void setMaxSize(Long maxSize) {
        this.maxSize = maxSize;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UploadShare uploadShare = (UploadShare)o;
        return Objects.equals(this.id, uploadShare.id) && Objects.equals(this.targetId, uploadShare.targetId) && Objects.equals(this.name, uploadShare.name) && Objects.equals(this.isProtected, uploadShare.isProtected) && Objects.equals(this.accessKey, uploadShare.accessKey) && Objects.equals(this.expireAt, uploadShare.expireAt) && Objects.equals(this.notifyCreator, uploadShare.notifyCreator) && Objects.equals(this.createdAt, uploadShare.createdAt) && Objects.equals(this.createdBy, uploadShare.createdBy) && Objects.equals(this.targetPath, uploadShare.targetPath) && Objects.equals(this.isEncrypted, uploadShare.isEncrypted) && Objects.equals(this.notes, uploadShare.notes) && Objects.equals(this.filesExpiryPeriod, uploadShare.filesExpiryPeriod) && Objects.equals(this.recipients, uploadShare.recipients) && Objects.equals(this.smsRecipients, uploadShare.smsRecipients) && Objects.equals(this.cntFiles, uploadShare.cntFiles) && Objects.equals(this.cntUploads, uploadShare.cntUploads) && Objects.equals(this.showUploadedFiles, uploadShare.showUploadedFiles) && Objects.equals(this.dataUrl, uploadShare.dataUrl) && Objects.equals(this.maxSlots, uploadShare.maxSlots) && Objects.equals(this.maxSize, uploadShare.maxSize);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.targetId, this.name, this.isProtected, this.accessKey, this.expireAt, this.notifyCreator, this.createdAt, this.createdBy, this.targetPath, this.isEncrypted, this.notes, this.filesExpiryPeriod, this.recipients, this.smsRecipients, this.cntFiles, this.cntUploads, this.showUploadedFiles, this.dataUrl, this.maxSlots, this.maxSize);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UploadShare {\n");
        sb.append("    id: ").append(this.toIndentedString(this.id)).append("\n");
        sb.append("    targetId: ").append(this.toIndentedString(this.targetId)).append("\n");
        sb.append("    name: ").append(this.toIndentedString(this.name)).append("\n");
        sb.append("    isProtected: ").append(this.toIndentedString(this.isProtected)).append("\n");
        sb.append("    accessKey: ").append(this.toIndentedString(this.accessKey)).append("\n");
        sb.append("    expireAt: ").append(this.toIndentedString(this.expireAt)).append("\n");
        sb.append("    notifyCreator: ").append(this.toIndentedString(this.notifyCreator)).append("\n");
        sb.append("    createdAt: ").append(this.toIndentedString(this.createdAt)).append("\n");
        sb.append("    createdBy: ").append(this.toIndentedString(this.createdBy)).append("\n");
        sb.append("    targetPath: ").append(this.toIndentedString(this.targetPath)).append("\n");
        sb.append("    isEncrypted: ").append(this.toIndentedString(this.isEncrypted)).append("\n");
        sb.append("    notes: ").append(this.toIndentedString(this.notes)).append("\n");
        sb.append("    filesExpiryPeriod: ").append(this.toIndentedString(this.filesExpiryPeriod)).append("\n");
        sb.append("    recipients: ").append(this.toIndentedString(this.recipients)).append("\n");
        sb.append("    smsRecipients: ").append(this.toIndentedString(this.smsRecipients)).append("\n");
        sb.append("    cntFiles: ").append(this.toIndentedString(this.cntFiles)).append("\n");
        sb.append("    cntUploads: ").append(this.toIndentedString(this.cntUploads)).append("\n");
        sb.append("    showUploadedFiles: ").append(this.toIndentedString(this.showUploadedFiles)).append("\n");
        sb.append("    dataUrl: ").append(this.toIndentedString(this.dataUrl)).append("\n");
        sb.append("    maxSlots: ").append(this.toIndentedString(this.maxSlots)).append("\n");
        sb.append("    maxSize: ").append(this.toIndentedString(this.maxSize)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }
}

