/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.UnixPermission;
import ch.cyberduck.core.vault.VaultRegistry;

public class VaultRegistryUnixPermissionFeature
implements UnixPermission {
    private final Session<?> session;
    private final UnixPermission proxy;
    private final VaultRegistry registry;

    public VaultRegistryUnixPermissionFeature(Session<?> session, UnixPermission proxy, VaultRegistry registry) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public void setUnixOwner(Path file, String owner) throws BackgroundException {
        this.registry.find(this.session, file).getFeature(this.session, UnixPermission.class, this.proxy).setUnixOwner(file, owner);
    }

    @Override
    public void setUnixGroup(Path file, String group) throws BackgroundException {
        this.registry.find(this.session, file).getFeature(this.session, UnixPermission.class, this.proxy).setUnixGroup(file, group);
    }

    @Override
    public Permission getUnixPermission(Path file) throws BackgroundException {
        return this.registry.find(this.session, file).getFeature(this.session, UnixPermission.class, this.proxy).getUnixPermission(file);
    }

    @Override
    public void setUnixPermission(Path file, Permission permission) throws BackgroundException {
        this.registry.find(this.session, file).getFeature(this.session, UnixPermission.class, this.proxy).setUnixPermission(file, permission);
    }

    @Override
    public Permission getDefault(Local file) {
        return this.proxy.getDefault(file);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryUnixPermissionFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

