/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cache;

import com.google.common.cache.CacheBuilder;
import com.google.common.cache.CacheLoader;
import com.google.common.cache.LoadingCache;
import com.google.common.util.concurrent.UncheckedExecutionException;
import java.util.function.BiConsumer;
import java.util.function.Function;

public class LRUCache<Key, Value> {
    private final LoadingCache<Key, Value> delegate;

    public static <Key, Value> LRUCache<Key, Value> usingLoader(Function<Key, Value> loader, long maximumSize) {
        return new LRUCache<Key, Value>(loader, maximumSize);
    }

    private LRUCache(final Function<Key, Value> loader, long maximumSize) {
        this.delegate = CacheBuilder.newBuilder().maximumSize(maximumSize).build(new CacheLoader<Key, Value>(){

            public Value load(Key key) {
                return loader.apply(key);
            }
        });
    }

    public Value get(Key key) throws UncheckedExecutionException {
        return (Value)this.delegate.getUnchecked(key);
    }

    public void forEach(BiConsumer<Key, Value> function) {
        this.delegate.asMap().forEach(function);
    }

    public void put(Key key, Value value) {
        this.delegate.put(key, value);
    }

    public void remove(Key key) {
        this.delegate.invalidate(key);
    }
}

