/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.CacheReference;
import ch.cyberduck.core.Referenceable;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Set;
import org.apache.log4j.Logger;

public class ReverseLookupCache<T extends Referenceable>
implements Cache<T> {
    private static final Logger log = Logger.getLogger(ReverseLookupCache.class);
    private final Cache<T> proxy;
    private final Map<CacheReference, T> reverse;

    public ReverseLookupCache(Cache<T> proxy, int size) {
        this.proxy = proxy;
        this.reverse = size == Integer.MAX_VALUE ? Collections.synchronizedMap(new LinkedHashMap()) : (size == 0 ? Collections.emptyMap() : Collections.synchronizedMap(new LinkedHashMap()));
    }

    @Override
    public CacheReference key(T object) {
        return this.proxy.key(object);
    }

    @Override
    public boolean isCached(T parent) {
        return this.proxy.isCached(parent);
    }

    @Override
    public boolean isEmpty() {
        return this.proxy.isEmpty();
    }

    @Override
    public boolean isValid(T item) {
        return this.proxy.isValid(item);
    }

    @Override
    public AttributedList<T> put(T reference, AttributedList<T> children) {
        for (Referenceable f : children) {
            CacheReference key = this.proxy.key(f);
            this.reverse.remove(key);
            this.reverse.put(key, reference);
        }
        return this.proxy.put(reference, children);
    }

    @Override
    public AttributedList<T> get(T parent) {
        return this.proxy.get(parent);
    }

    @Override
    public T lookup(CacheReference reference) {
        Referenceable[] entries;
        Referenceable parent = (Referenceable)this.reverse.get(reference);
        AttributedList<Referenceable> list = this.proxy.get(parent);
        if (list.isEmpty()) {
            log.warn((Object)String.format("Lookup failed for %s in reverse cache", reference));
            return null;
        }
        for (Referenceable entry : entries = list.toArray()) {
            if (!this.proxy.key(entry).equals(reference)) continue;
            return (T)entry;
        }
        log.warn((Object)String.format("Lookup failed for %s in reverse cache", reference));
        return null;
    }

    @Override
    public AttributedList<T> remove(T reference) {
        AttributedList<T> removed = this.proxy.remove(reference);
        for (Referenceable r : removed) {
            this.reverse.remove(this.proxy.key(r));
        }
        return removed;
    }

    @Override
    public Set<T> keySet() {
        return this.proxy.keySet();
    }

    @Override
    public void invalidate(T parent) {
        this.proxy.invalidate(parent);
    }

    @Override
    public void clear() {
        this.proxy.clear();
        this.reverse.clear();
    }
}

