/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core;

import ch.cyberduck.core.Filter;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Profile;
import ch.cyberduck.core.ProfileReaderFactory;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.Scheme;
import ch.cyberduck.core.exception.AccessDeniedException;
import ch.cyberduck.core.preferences.ApplicationResourcesFinderFactory;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.preferences.SupportDirectoryFinderFactory;
import java.util.Arrays;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.function.Predicate;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import org.apache.commons.io.FilenameUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public final class ProtocolFactory {
    private static final Logger log = Logger.getLogger(ProtocolFactory.class);
    private static final ProtocolFactory global = new ProtocolFactory();
    private final Set<Protocol> registered;
    private final Local bundle;

    public static ProtocolFactory get() {
        return global;
    }

    public ProtocolFactory() {
        this(new LinkedHashSet<Protocol>());
    }

    public ProtocolFactory(Set<Protocol> protocols) {
        this(LocalFactory.get(ApplicationResourcesFinderFactory.get().find(), PreferencesFactory.get().getProperty("profiles.folder.name")), protocols);
    }

    public ProtocolFactory(Local bundle, Set<Protocol> protocols) {
        this.bundle = bundle;
        this.registered = protocols;
    }

    public void register(Protocol ... protocols) {
        Local library;
        for (Protocol protocol : protocols) {
            this.register(protocol);
        }
        if (this.bundle.exists()) {
            try {
                for (Local f : this.bundle.list().filter(new ProfileFilter())) {
                    Profile profile = ProfileReaderFactory.get().read(f);
                    if (null == profile) continue;
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Adding bundled protocol %s", profile));
                    }
                    this.registered.add(profile);
                }
            }
            catch (AccessDeniedException e) {
                log.warn((Object)String.format("Failure reading collection %s %s", this.bundle, e.getMessage()));
            }
        }
        if ((library = LocalFactory.get(SupportDirectoryFinderFactory.get().find(), PreferencesFactory.get().getProperty("profiles.folder.name"))).exists()) {
            try {
                for (Local profile : library.list().filter(new ProfileFilter())) {
                    Protocol protocol;
                    protocol = ProfileReaderFactory.get().read(profile);
                    if (null == protocol) continue;
                    if (log.isInfoEnabled()) {
                        log.info((Object)String.format("Adding thirdparty protocol %s", protocol));
                    }
                    this.registered.add(protocol);
                }
            }
            catch (AccessDeniedException e) {
                log.warn((Object)String.format("Failure reading collection %s %s", library, e.getMessage()));
            }
        }
    }

    public void register(Protocol protocol) {
        if (null == protocol) {
            log.error((Object)"Attempt to register unknown protocol");
            return;
        }
        this.registered.add(protocol);
    }

    public List<Protocol> find() {
        return this.find(Protocol::isEnabled);
    }

    public List<Protocol> find(Predicate<Protocol> search) {
        return this.registered.stream().filter(search).sorted().collect(Collectors.toList());
    }

    public Protocol forName(String identifier) {
        List<Protocol> enabled = this.find();
        return enabled.stream().filter(protocol -> String.valueOf(protocol.hashCode()).equals(identifier)).findFirst().orElse(this.forName(enabled, identifier, null));
    }

    public Protocol forName(String identifier, String provider) {
        List<Protocol> enabled = this.find();
        return this.forName(enabled, identifier, provider);
    }

    public Protocol forName(List<Protocol> enabled, String identifier, String provider) {
        Protocol match = enabled.stream().filter(protocol -> {
            if (StringUtils.equals((CharSequence)protocol.getIdentifier(), (CharSequence)identifier)) {
                if (null == provider) {
                    return true;
                }
                return StringUtils.equals((CharSequence)protocol.getProvider(), (CharSequence)provider);
            }
            return StringUtils.equals((CharSequence)String.format("%s-%s", protocol.getIdentifier(), protocol.getProvider()), (CharSequence)identifier);
        }).findFirst().orElse(enabled.stream().filter(protocol -> StringUtils.equals((CharSequence)protocol.getIdentifier(), (CharSequence)identifier)).findFirst().orElse(enabled.stream().filter(protocol -> StringUtils.equals((CharSequence)protocol.getProvider(), (CharSequence)identifier)).findFirst().orElse(enabled.stream().filter(protocol -> StringUtils.equals((CharSequence)protocol.getType().name(), (CharSequence)identifier)).findFirst().orElse(this.forScheme(enabled, identifier)))));
        if (null == match) {
            if (enabled.isEmpty()) {
                log.error((Object)String.format("List of registered protocols in %s is empty", this));
            }
            log.error((Object)String.format("Missing registered protocol for identifier %s", identifier));
        }
        return match;
    }

    public Protocol forType(Protocol.Type type) {
        List<Protocol> enabled = this.find();
        return this.forType(enabled, type);
    }

    private Protocol forType(List<Protocol> enabled, Protocol.Type type) {
        return enabled.stream().filter(protocol -> protocol.getType().equals((Object)type)).findFirst().orElse(null);
    }

    public Protocol forScheme(List<Protocol> enabled, String scheme) {
        try {
            return this.forScheme(Scheme.valueOf(scheme));
        }
        catch (IllegalArgumentException e) {
            log.warn((Object)String.format("Unknown scheme %s", scheme));
            return null;
        }
    }

    public Protocol forScheme(Scheme scheme) {
        List<Protocol> enabled = this.find();
        return this.forScheme(enabled, scheme);
    }

    private Protocol forScheme(List<Protocol> enabled, Scheme scheme) {
        Scheme filter;
        switch (scheme) {
            case http: {
                filter = Scheme.dav;
                break;
            }
            case https: {
                filter = Scheme.davs;
                break;
            }
            default: {
                filter = scheme;
            }
        }
        return enabled.stream().filter(protocol -> Arrays.asList(protocol.getSchemes()).contains((Object)filter)).findFirst().orElse(enabled.stream().filter(protocol -> Arrays.asList(protocol.getSchemes()).contains((Object)scheme)).findFirst().orElse(null));
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("ProtocolFactory{");
        sb.append("registered=").append(this.registered);
        sb.append(", bundle=").append(this.bundle);
        sb.append('}');
        return sb.toString();
    }

    private static final class ProfileFilter
    implements Filter<Local> {
        private ProfileFilter() {
        }

        @Override
        public boolean accept(Local file) {
            return "cyberduckprofile".equals(FilenameUtils.getExtension((String)file.getName()));
        }

        @Override
        public Pattern toPattern() {
            return Pattern.compile(".*\\.cyberduckprofile");
        }
    }
}

