/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.multipart;

import com.joyent.manta.util.NotThreadSafe;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;

@NotThreadSafe
public class MultipartOutputStream
extends OutputStream {
    private OutputStream wrapped = null;
    private ByteArrayOutputStream buf;
    private int blockSize;

    private MultipartOutputStream() {
    }

    public MultipartOutputStream(int blockSize) {
        this.blockSize = blockSize;
        this.buf = new ByteArrayOutputStream(blockSize);
    }

    public MultipartOutputStream(int blockSize, ByteArrayOutputStream buf) {
        this.blockSize = blockSize;
        this.buf = buf;
    }

    public void setNext(OutputStream next) {
        this.wrapped = next;
    }

    public byte[] getRemainder() {
        return this.buf.toByteArray();
    }

    @Override
    public void close() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void flush() throws IOException {
        this.wrapped.flush();
    }

    @Override
    public void write(byte[] buffer) throws IOException {
        int outstanding = this.buf.size() + buffer.length;
        if (outstanding < this.blockSize) {
            this.buf.write(buffer);
        } else {
            int remainder = outstanding % this.blockSize;
            this.flushBuffer();
            this.wrapped.write(buffer, 0, buffer.length - remainder);
            this.buf.write(buffer, buffer.length - remainder, remainder);
        }
    }

    public void flushBuffer() throws IOException {
        this.wrapped.write(this.buf.toByteArray());
        this.buf.reset();
    }

    @Override
    public void write(byte[] buffer, int offset, int length) throws IOException {
        this.write(Arrays.copyOfRange(buffer, offset, offset + length));
    }

    @Override
    public void write(int value) throws IOException {
        this.wrapped.write(value);
    }

    public ByteArrayOutputStream getBuf() {
        return this.buf;
    }
}

