/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.multipart;

import com.joyent.manta.client.crypto.EncryptionContext;
import com.joyent.manta.client.multipart.MultipartOutputStream;
import com.joyent.manta.exception.MantaMultipartException;
import com.joyent.manta.util.HmacOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Objects;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.lang3.Validate;
import org.bouncycastle.crypto.macs.HMac;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class EncryptionState {
    private static final transient Logger LOGGER = LoggerFactory.getLogger(EncryptionState.class);
    static final int NOT_STARTED = -1;
    private final EncryptionContext encryptionContext;
    private final ReentrantLock lock;
    private int lastPartNumber = -1;
    private transient MultipartOutputStream multipartStream = null;
    private transient OutputStream cipherStream = null;
    private boolean lastPartAuthWritten = false;

    private EncryptionState() {
        this.encryptionContext = null;
        this.lock = new ReentrantLock();
    }

    public EncryptionState(EncryptionContext encryptionContext) {
        this.encryptionContext = encryptionContext;
        this.lock = new ReentrantLock();
    }

    EncryptionContext getEncryptionContext() {
        return this.encryptionContext;
    }

    ReentrantLock getLock() {
        return this.lock;
    }

    int getLastPartNumber() {
        return this.lastPartNumber;
    }

    MultipartOutputStream getMultipartStream() {
        return this.multipartStream;
    }

    OutputStream getCipherStream() {
        return this.cipherStream;
    }

    void setLastPartNumber(int lastPartNumber) {
        this.lastPartNumber = lastPartNumber;
    }

    void setMultipartStream(MultipartOutputStream multipartStream) {
        this.multipartStream = multipartStream;
    }

    void setCipherStream(OutputStream cipherStream) {
        this.cipherStream = cipherStream;
    }

    boolean isLastPartAuthWritten() {
        return this.lastPartAuthWritten;
    }

    ByteArrayOutputStream remainderAndLastPartAuth() throws IOException {
        if (!this.getLock().isHeldByCurrentThread()) {
            throw new IllegalStateException("remainderAndLastPartAuth called without lock owned");
        }
        if (this.isLastPartAuthWritten()) {
            String msg = "final CSE auth already written (complete called multiple times or parts below min size)";
            MantaMultipartException mme = new MantaMultipartException(new IllegalStateException("final CSE auth already written (complete called multiple times or parts below min size)"));
            mme.setContextValue("lastPartNumber", this.getLastPartNumber());
            throw mme;
        }
        ByteArrayOutputStream remainderStream = new ByteArrayOutputStream();
        this.getMultipartStream().setNext(remainderStream);
        this.getCipherStream().close();
        remainderStream.write(this.getMultipartStream().getRemainder());
        if (this.getCipherStream().getClass().equals(HmacOutputStream.class)) {
            HMac hmac = ((HmacOutputStream)this.getCipherStream()).getHmac();
            byte[] hmacBytes = new byte[hmac.getMacSize()];
            hmac.doFinal(hmacBytes, 0);
            int hmacSize = this.encryptionContext.getCipherDetails().getAuthenticationTagOrHmacLengthInBytes();
            Validate.isTrue((hmacBytes.length == hmacSize ? 1 : 0) != 0, (String)"HMAC actual bytes doesn't equal the number of bytes expected", (Object[])new Object[0]);
            if (LOGGER.isTraceEnabled()) {
                LOGGER.trace("HMAC: {}", (Object)Hex.encodeHexString((byte[])hmacBytes));
            }
            remainderStream.write(hmacBytes);
        }
        this.lastPartAuthWritten = true;
        return remainderStream;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        EncryptionState that = (EncryptionState)o;
        return this.lastPartNumber == that.lastPartNumber && this.lastPartAuthWritten == that.lastPartAuthWritten && Objects.equals(this.encryptionContext, that.encryptionContext);
    }

    public int hashCode() {
        return Objects.hash(this.encryptionContext, this.lastPartNumber);
    }
}

