/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.utils;

import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.lang.reflect.Method;
import java.security.MessageDigest;
import java.security.NoSuchAlgorithmException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.exception.JargonException;
import org.irods.jargon.core.exception.PathTooLongException;
import org.irods.jargon.core.pub.domain.ObjStat;
import org.irods.jargon.core.utils.CollectionAndPath;
import org.irods.jargon.core.utils.LocalFileUtils;

public class MiscIRODSUtils {
    private MiscIRODSUtils() {
    }

    public static String getDefaultIRODSResourceFromAccountIfFileInZone(String irodsAbsolutePath, IRODSAccount irodsAccount) {
        String defaultResource = "";
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null irodsAbsolutePath");
        }
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        List<String> pathComponents = MiscIRODSUtils.breakIRODSPathIntoComponents(irodsAbsolutePath);
        boolean inZone = MiscIRODSUtils.isFirstPartOfPathInZone(irodsAccount, pathComponents);
        if (inZone) {
            defaultResource = irodsAccount.getDefaultStorageResource();
        }
        return defaultResource;
    }

    public static boolean isFileInThisZone(String irodsAbsolutePath, IRODSAccount irodsAccount) {
        boolean inZone = true;
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null irodsAbsolutePath");
        }
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        List<String> pathComponents = MiscIRODSUtils.breakIRODSPathIntoComponents(irodsAbsolutePath);
        inZone = MiscIRODSUtils.isFirstPartOfPathInZone(irodsAccount, pathComponents);
        return inZone;
    }

    public static String getZoneInPath(String irodsAbsolutePath) {
        if (irodsAbsolutePath == null) {
            throw new IllegalArgumentException("null  irodsAbsolutePath");
        }
        if (irodsAbsolutePath.isEmpty()) {
            return "";
        }
        List<String> pathComponents = MiscIRODSUtils.breakIRODSPathIntoComponents(irodsAbsolutePath);
        if (pathComponents.size() <= 1) {
            return "";
        }
        return pathComponents.get(1);
    }

    private static boolean isFirstPartOfPathInZone(IRODSAccount irodsAccount, List<String> pathComponents) {
        boolean inZone = true;
        if (!pathComponents.isEmpty() && pathComponents.size() != 1) {
            inZone = pathComponents.get(1).equals(irodsAccount.getZone());
        }
        return inZone;
    }

    public static List<String> breakIRODSPathIntoComponents(String irodsAbsolutePath) {
        if (irodsAbsolutePath == null || irodsAbsolutePath.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsAbsolutePath");
        }
        String[] components = irodsAbsolutePath.split("/");
        return Arrays.asList(components);
    }

    public static String buildPathFromComponentsUpToIndex(List<String> pathComponents, int lastIndex) {
        if (pathComponents == null) {
            throw new IllegalArgumentException("null pathComponents");
        }
        StringBuilder sb = new StringBuilder();
        int i = 0;
        for (String pathComponent : pathComponents) {
            if (pathComponent.isEmpty()) continue;
            if (lastIndex >= 0 && i++ >= lastIndex) break;
            sb.append("/");
            sb.append(pathComponent);
        }
        if (sb.length() == 0) {
            sb.append("/");
        }
        return sb.toString();
    }

    public static String convertStreamToString(InputStream inputStream) throws Exception {
        int read;
        char[] buffer = new char[65536];
        StringBuilder out = new StringBuilder();
        InputStreamReader in = new InputStreamReader(inputStream, "UTF-8");
        do {
            if ((read = ((Reader)in).read(buffer, 0, buffer.length)) <= 0) continue;
            out.append(buffer, 0, read);
        } while (read >= 0);
        String result = out.toString();
        return result;
    }

    public static String getUserInUserName(String userName) {
        if (userName == null || userName.isEmpty()) {
            return "";
        }
        int indexOfPound = userName.indexOf(35);
        if (indexOfPound == -1) {
            return userName;
        }
        return userName.substring(0, indexOfPound);
    }

    public static String getZoneInUserName(String userName) {
        if (userName == null || userName.isEmpty()) {
            return "";
        }
        int indexOfPound = userName.indexOf(35);
        if (indexOfPound == -1) {
            return "";
        }
        return userName.substring(indexOfPound + 1);
    }

    public static String humanReadableByteCount(long bytes) {
        int unit = 1024;
        if (bytes < (long)unit) {
            return bytes + " B";
        }
        int exp = (int)(Math.log(bytes) / Math.log(unit));
        char pre = "KMGTPE".charAt(exp - 1);
        return String.format("%.1f %sB", (double)bytes / Math.pow(unit, exp), Character.valueOf(pre));
    }

    public static String computeMD5HashOfAStringValue(String input) throws JargonException {
        if (input == null || input.isEmpty()) {
            throw new IllegalArgumentException("null or empty input");
        }
        try {
            MessageDigest algorithm = MessageDigest.getInstance("MD5");
            algorithm.reset();
            algorithm.update(input.getBytes());
            byte[] md5 = algorithm.digest();
            return LocalFileUtils.digestByteArrayToString(md5);
        }
        catch (NoSuchAlgorithmException ex) {
            throw new JargonException("exception creating MD5 Hash of the given string", ex);
        }
    }

    public static String computeHomeDirectoryForIRODSAccount(IRODSAccount irodsAccount) {
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("/");
        sb.append(irodsAccount.getZone());
        sb.append("/home/");
        sb.append(irodsAccount.getUserName());
        return sb.toString();
    }

    public static String computeHomeDirectoryForIRODSAccountInFederatedZone(IRODSAccount irodsAccount, String zone) {
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("/");
        sb.append(zone);
        sb.append("/home/");
        sb.append(irodsAccount.getUserName());
        sb.append("#");
        sb.append(irodsAccount.getZone());
        return sb.toString();
    }

    public static String computeHomeDirectoryForGivenUserInSameZoneAsIRODSAccount(IRODSAccount irodsAccount, String irodsUserName) {
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        if (irodsUserName == null || irodsUserName.isEmpty()) {
            throw new IllegalArgumentException("null or empty irodsUserName");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("/");
        sb.append(irodsAccount.getZone());
        sb.append("/home/");
        sb.append(irodsUserName);
        return sb.toString();
    }

    public static String computePublicDirectory(IRODSAccount irodsAccount) {
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        StringBuilder sb = new StringBuilder();
        sb.append("/");
        sb.append(irodsAccount.getZone());
        sb.append("/home/public");
        return sb.toString();
    }

    public static String getLastPathComponentForGiveAbsolutePath(String collectionPath) {
        if (collectionPath == null || collectionPath.isEmpty()) {
            throw new IllegalArgumentException("null or empty collection path");
        }
        String[] paths = collectionPath.split("/");
        if (paths.length == 0) {
            return "";
        }
        return paths[paths.length - 1];
    }

    public static void evaluateSpecCollSupport(ObjStat objStat) throws JargonException {
        if (objStat.getSpecColType() != ObjStat.SpecColType.LINKED_COLL && objStat.getSpecColType() != ObjStat.SpecColType.NORMAL && objStat.getSpecColType() != ObjStat.SpecColType.STRUCT_FILE_COLL && objStat.getSpecColType() != ObjStat.SpecColType.MOUNTED_COLL) {
            throw new JargonException("unsupported object type, support not yet available for:" + (Object)((Object)objStat.getSpecColType()));
        }
    }

    public static String buildAbsolutePathFromCollectionParentAndFileName(String collectionPath, String dataName) {
        if (collectionPath == null) {
            throw new IllegalArgumentException("null or empty collectionPath");
        }
        if (dataName == null) {
            throw new IllegalArgumentException("null or empty dataName");
        }
        StringBuilder pathBuilder = new StringBuilder();
        if (collectionPath.isEmpty() && dataName.isEmpty()) {
            pathBuilder.append("/");
        } else {
            pathBuilder.append(collectionPath);
            if (!collectionPath.isEmpty() && collectionPath.charAt(collectionPath.length() - 1) != '/') {
                pathBuilder.append('/');
            }
            pathBuilder.append(dataName);
        }
        return pathBuilder.toString();
    }

    public static String determineAbsolutePathBasedOnCollTypeInObjectStat(ObjStat objStat) {
        String effectiveAbsolutePath = null;
        effectiveAbsolutePath = objStat.getSpecColType() == ObjStat.SpecColType.LINKED_COLL ? objStat.getObjectPath() : objStat.getAbsolutePath();
        return effectiveAbsolutePath;
    }

    public static CollectionAndPath separateCollectionAndPathFromGivenAbsolutePath(String filePath) {
        if (filePath == null) {
            throw new NullPointerException("The file name cannot be null");
        }
        String fileName = filePath;
        String directory = "";
        if (fileName.length() > 1) {
            int index = fileName.lastIndexOf(47);
            while (index == fileName.length() - 1 && index >= 0) {
                fileName = fileName.substring(0, index);
                index = fileName.lastIndexOf(47);
            }
            if (index >= 0 && fileName.substring(index + 1).length() > 0) {
                directory = fileName.substring(0, index);
                fileName = fileName.substring(index + 1);
            }
        }
        return new CollectionAndPath(directory, fileName);
    }

    public static <T extends Enum<T>> List<String> getDisplayValuesFromEnum(Class<T> enumClass) throws JargonException {
        try {
            Enum[] items = (Enum[])enumClass.getEnumConstants();
            Method accessor = enumClass.getMethod("toString", new Class[0]);
            ArrayList<String> names = new ArrayList<String>(items.length);
            for (Enum item : items) {
                names.add(accessor.invoke((Object)item, new Object[0]).toString());
            }
            return names;
        }
        catch (Exception ex) {
            throw new JargonException("error getting enum vals", ex);
        }
    }

    public static int countCharsInString(String stringToCountOccurrancesIn, char characterToCount) {
        if (stringToCountOccurrancesIn == null) {
            throw new IllegalArgumentException("null s");
        }
        char[] chars = stringToCountOccurrancesIn.toCharArray();
        int count = 0;
        for (char c : chars) {
            if (c != characterToCount) continue;
            ++count;
        }
        return count;
    }

    public static String padRight(String s, int n) {
        return String.format("%1$-" + n + "s", s);
    }

    public static String padLeft(String s, int n) {
        return String.format("%1$" + n + "s", s);
    }

    public static String checkPathSizeForMax(String path) throws PathTooLongException {
        if (path == null) {
            throw new IllegalArgumentException("null path");
        }
        if (path.length() > 1024) {
            throw new PathTooLongException("Path is too long");
        }
        String retPath = null;
        retPath = path.endsWith("/") ? (path.length() == 1 ? path : path.substring(0, path.length() - 1)) : path;
        return retPath;
    }

    public static String buildIRODSUserHomeForAccountUsingDefaultScheme(IRODSAccount irodsAccount) {
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        StringBuilder sb = new StringBuilder();
        sb.append('/');
        sb.append(irodsAccount.getZone());
        sb.append("/home/");
        sb.append(irodsAccount.getUserName());
        return sb.toString();
    }

    public static void checkPathSizeForMax(String parentPath, String childPath) throws PathTooLongException {
        if (parentPath == null) {
            throw new IllegalArgumentException("null parentPath");
        }
        if (childPath == null) {
            throw new IllegalArgumentException("null childPath");
        }
        if (childPath.length() + childPath.length() > 1024) {
            throw new PathTooLongException("Path is too long");
        }
    }

    public static final String abbreviateFileName(String fileName) {
        if (fileName == null) {
            throw new IllegalArgumentException("null fileName");
        }
        StringBuilder sb = new StringBuilder();
        if (fileName.length() < 100) {
            sb.append(fileName);
        } else {
            sb.append(fileName.substring(0, 50));
            sb.append(" ... ");
            sb.append(fileName.substring(fileName.length() - 50));
        }
        return sb.toString();
    }

    public static final String wrapStringInQuotes(String string) {
        if (string == null) {
            throw new IllegalArgumentException("null string");
        }
        StringBuilder sBuilder = new StringBuilder();
        sBuilder.append("\"");
        sBuilder.append(string);
        sBuilder.append("\"");
        return sBuilder.toString();
    }

    public static final String subtractPrefixFromGivenPath(String prefix, String path) throws JargonException {
        int pathSize;
        if (prefix == null) {
            throw new IllegalArgumentException("null prefix");
        }
        if (path == null || path.isEmpty()) {
            throw new IllegalArgumentException("null or empty path");
        }
        int prefixSize = prefix.length();
        if (prefixSize >= (pathSize = path.length())) {
            throw new JargonException("given path does not contain the prefix");
        }
        String pathFirst = path.substring(0, prefixSize);
        if (!pathFirst.equals(prefix)) {
            throw new JargonException("given path does not contain the prefix");
        }
        return path.substring(prefixSize);
    }
}

