/*
 * Decompiled with CFR 0.152.
 */
package org.irods.jargon.core.connection;

import org.irods.jargon.core.connection.AbstractIRODSMidLevelProtocol;
import org.irods.jargon.core.connection.AbstractIRODSMidLevelProtocolFactory;
import org.irods.jargon.core.connection.AuthenticationFactory;
import org.irods.jargon.core.connection.AuthenticationFactoryImpl;
import org.irods.jargon.core.connection.IRODSAccount;
import org.irods.jargon.core.connection.IRODSConnectionFactoryProducingFactory;
import org.irods.jargon.core.connection.IRODSSession;
import org.irods.jargon.core.connection.PipelineConfiguration;
import org.irods.jargon.core.exception.AuthenticationException;
import org.irods.jargon.core.exception.JargonException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class IRODSProtocolManager {
    private AuthenticationFactory authenticationFactory = new AuthenticationFactoryImpl();
    private IRODSConnectionFactoryProducingFactory irodsConnectionFactoryProducingFactory = new IRODSConnectionFactoryProducingFactory();
    private AbstractIRODSMidLevelProtocolFactory irodsMidLevelProtocolFactory;
    private Logger log = LoggerFactory.getLogger(IRODSProtocolManager.class);

    AuthenticationFactory getAuthenticationFactory() {
        return this.authenticationFactory;
    }

    public void setAuthenticationFactory(AuthenticationFactory authenticationFactory) {
        if (authenticationFactory == null) {
            throw new IllegalArgumentException("null authenticationFactory");
        }
        this.authenticationFactory = authenticationFactory;
    }

    public abstract AbstractIRODSMidLevelProtocol getIRODSProtocol(IRODSAccount var1, PipelineConfiguration var2, IRODSSession var3) throws AuthenticationException, JargonException;

    protected abstract void returnIRODSProtocol(AbstractIRODSMidLevelProtocol var1) throws JargonException;

    protected AbstractIRODSMidLevelProtocol createNewProtocol(IRODSAccount irodsAccount, PipelineConfiguration pipelineConfiguration, IRODSSession irodsSession) throws AuthenticationException, JargonException {
        this.log.debug("creating a fresh AbstractIRODSMidLevelProtocol for account:{}", (Object)irodsAccount);
        if (irodsAccount == null) {
            throw new IllegalArgumentException("null irodsAccount");
        }
        if (pipelineConfiguration == null) {
            throw new IllegalArgumentException("null pipelineConfiguration");
        }
        if (irodsSession == null) {
            throw new IllegalArgumentException("null irodsSession");
        }
        return this.getIrodsMidLevelProtocolFactory().instance(irodsSession, irodsAccount, this);
    }

    protected void returnWithForce(AbstractIRODSMidLevelProtocol irodsMidLevelProtocol) {
        this.log.warn("connection returned with IOException, will forcefully close and remove from session cache");
        if (irodsMidLevelProtocol != null) {
            irodsMidLevelProtocol.obliterateConnectionAndDiscardErrors();
        }
    }

    protected synchronized void destroy() throws JargonException {
        this.log.debug("destroy called, this will terminate the session and clear it");
    }

    public synchronized void initialize() throws JargonException {
        this.log.debug("initialize called, does nothing by default");
    }

    synchronized IRODSConnectionFactoryProducingFactory getIrodsConnectionFactoryProducingFactory() {
        return this.irodsConnectionFactoryProducingFactory;
    }

    synchronized void setIrodsConnectionFactoryProducingFactory(IRODSConnectionFactoryProducingFactory irodsConnectionFactoryProducingFactory) {
        this.irodsConnectionFactoryProducingFactory = irodsConnectionFactoryProducingFactory;
    }

    public synchronized AbstractIRODSMidLevelProtocolFactory getIrodsMidLevelProtocolFactory() {
        return this.irodsMidLevelProtocolFactory;
    }

    public synchronized void setIrodsMidLevelProtocolFactory(AbstractIRODSMidLevelProtocolFactory irodsMidLevelProtocolFactory) {
        this.irodsMidLevelProtocolFactory = irodsMidLevelProtocolFactory;
    }
}

