/*
 * Decompiled with CFR 0.152.
 */
package com.dropbox.core.v2.team;

import com.dropbox.core.stone.StoneSerializers;
import com.dropbox.core.stone.StructSerializer;
import com.dropbox.core.v2.team.TeamFolderStatus;
import com.fasterxml.jackson.core.JsonGenerationException;
import com.fasterxml.jackson.core.JsonGenerator;
import com.fasterxml.jackson.core.JsonParseException;
import com.fasterxml.jackson.core.JsonParser;
import com.fasterxml.jackson.core.JsonToken;
import java.io.IOException;
import java.util.Arrays;
import java.util.regex.Pattern;

public class TeamFolderMetadata {
    protected final String teamFolderId;
    protected final String name;
    protected final TeamFolderStatus status;
    protected final boolean isTeamSharedDropbox;

    public TeamFolderMetadata(String teamFolderId, String name, TeamFolderStatus status, boolean isTeamSharedDropbox) {
        if (teamFolderId == null) {
            throw new IllegalArgumentException("Required value for 'teamFolderId' is null");
        }
        if (!Pattern.matches("[-_0-9a-zA-Z:]+", teamFolderId)) {
            throw new IllegalArgumentException("String 'teamFolderId' does not match pattern");
        }
        this.teamFolderId = teamFolderId;
        if (name == null) {
            throw new IllegalArgumentException("Required value for 'name' is null");
        }
        this.name = name;
        if (status == null) {
            throw new IllegalArgumentException("Required value for 'status' is null");
        }
        this.status = status;
        this.isTeamSharedDropbox = isTeamSharedDropbox;
    }

    public String getTeamFolderId() {
        return this.teamFolderId;
    }

    public String getName() {
        return this.name;
    }

    public TeamFolderStatus getStatus() {
        return this.status;
    }

    public boolean getIsTeamSharedDropbox() {
        return this.isTeamSharedDropbox;
    }

    public int hashCode() {
        int hash = Arrays.hashCode(new Object[]{this.teamFolderId, this.name, this.status, this.isTeamSharedDropbox});
        return hash;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (obj.getClass().equals(this.getClass())) {
            TeamFolderMetadata other = (TeamFolderMetadata)obj;
            return !(this.teamFolderId != other.teamFolderId && !this.teamFolderId.equals(other.teamFolderId) || this.name != other.name && !this.name.equals(other.name) || this.status != other.status && !this.status.equals((Object)other.status) || this.isTeamSharedDropbox != other.isTeamSharedDropbox);
        }
        return false;
    }

    public String toString() {
        return Serializer.INSTANCE.serialize(this, false);
    }

    public String toStringMultiline() {
        return Serializer.INSTANCE.serialize(this, true);
    }

    static class Serializer
    extends StructSerializer<TeamFolderMetadata> {
        public static final Serializer INSTANCE = new Serializer();

        Serializer() {
        }

        @Override
        public void serialize(TeamFolderMetadata value, JsonGenerator g, boolean collapse) throws IOException, JsonGenerationException {
            if (!collapse) {
                g.writeStartObject();
            }
            g.writeFieldName("team_folder_id");
            StoneSerializers.string().serialize(value.teamFolderId, g);
            g.writeFieldName("name");
            StoneSerializers.string().serialize(value.name, g);
            g.writeFieldName("status");
            TeamFolderStatus.Serializer.INSTANCE.serialize(value.status, g);
            g.writeFieldName("is_team_shared_dropbox");
            StoneSerializers.boolean_().serialize((Boolean)value.isTeamSharedDropbox, g);
            if (!collapse) {
                g.writeEndObject();
            }
        }

        @Override
        public TeamFolderMetadata deserialize(JsonParser p, boolean collapsed) throws IOException, JsonParseException {
            Boolean f_isTeamSharedDropbox;
            TeamFolderStatus f_status;
            String f_name;
            String f_teamFolderId;
            String tag = null;
            if (!collapsed) {
                Serializer.expectStartObject(p);
                tag = Serializer.readTag(p);
            }
            if (tag == null) {
                f_teamFolderId = null;
                f_name = null;
                f_status = null;
                f_isTeamSharedDropbox = null;
                while (p.getCurrentToken() == JsonToken.FIELD_NAME) {
                    String field = p.getCurrentName();
                    p.nextToken();
                    if ("team_folder_id".equals(field)) {
                        f_teamFolderId = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("name".equals(field)) {
                        f_name = StoneSerializers.string().deserialize(p);
                        continue;
                    }
                    if ("status".equals(field)) {
                        f_status = TeamFolderStatus.Serializer.INSTANCE.deserialize(p);
                        continue;
                    }
                    if ("is_team_shared_dropbox".equals(field)) {
                        f_isTeamSharedDropbox = StoneSerializers.boolean_().deserialize(p);
                        continue;
                    }
                    Serializer.skipValue(p);
                }
                if (f_teamFolderId == null) {
                    throw new JsonParseException(p, "Required field \"team_folder_id\" missing.");
                }
                if (f_name == null) {
                    throw new JsonParseException(p, "Required field \"name\" missing.");
                }
                if (f_status == null) {
                    throw new JsonParseException(p, "Required field \"status\" missing.");
                }
                if (f_isTeamSharedDropbox == null) {
                    throw new JsonParseException(p, "Required field \"is_team_shared_dropbox\" missing.");
                }
            } else {
                throw new JsonParseException(p, "No subtype found that matches tag: \"" + tag + "\"");
            }
            TeamFolderMetadata value = new TeamFolderMetadata(f_teamFolderId, f_name, f_status, f_isTeamSharedDropbox);
            if (!collapsed) {
                Serializer.expectEndObject(p);
            }
            return value;
        }
    }
}

