/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.UnsupportedException;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Encryption;
import ch.cyberduck.core.features.Redundancy;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.Worker;
import java.text.MessageFormat;

public class CreateDirectoryWorker
extends Worker<Path> {
    private final Path folder;
    private final String region;

    public CreateDirectoryWorker(Path folder, String region) {
        this.folder = folder;
        this.region = region;
    }

    @Override
    public Path run(Session<?> session) throws BackgroundException {
        Redundancy redundancy;
        Directory feature = session.getFeature(Directory.class);
        if (!feature.isSupported(this.folder.getParent(), this.folder.getName())) {
            throw new UnsupportedException();
        }
        TransferStatus status = new TransferStatus();
        Encryption encryption = session.getFeature(Encryption.class);
        if (encryption != null) {
            status.setEncryption(encryption.getDefault(this.folder));
        }
        if ((redundancy = session.getFeature(Redundancy.class)) != null) {
            status.setStorageClass(redundancy.getDefault());
        }
        status.setTimestamp(System.currentTimeMillis());
        return feature.mkdir(this.folder, this.region, status);
    }

    @Override
    public Path initialize() {
        return this.folder;
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Making directory {0}", "Status"), this.folder.getName());
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        CreateDirectoryWorker that = (CreateDirectoryWorker)o;
        if (this.folder != null ? !this.folder.equals(that.folder) : that.folder != null) {
            return false;
        }
        return !(this.region == null ? that.region != null : !this.region.equals(that.region));
    }

    public int hashCode() {
        int result = this.folder != null ? this.folder.hashCode() : 0;
        result = 31 * result + (this.region != null ? this.region.hashCode() : 0);
        return result;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CreateDirectoryWorker{");
        sb.append("folder=").append(this.folder);
        sb.append(", region='").append(this.region).append('\'');
        sb.append('}');
        return sb.toString();
    }
}

