/*
 * Decompiled with CFR 0.152.
 */
package com.joyent.manta.client.multipart;

import java.io.Serializable;
import java.util.Objects;
import org.apache.commons.lang3.builder.ToStringBuilder;

public class MantaMultipartUploadTuple
implements Serializable,
Comparable<MantaMultipartUploadTuple> {
    private static final long serialVersionUID = -4050887694675747077L;
    private final int partNumber;
    private final String etag;

    public MantaMultipartUploadTuple(int partNumber, Object etag) {
        this(partNumber, Objects.toString(etag));
    }

    public MantaMultipartUploadTuple(int partNumber, String etag) {
        this.partNumber = partNumber;
        this.etag = etag;
    }

    public int getPartNumber() {
        return this.partNumber;
    }

    public String getEtag() {
        return this.etag;
    }

    @Override
    public int compareTo(MantaMultipartUploadTuple that) {
        return Integer.compare(this.getPartNumber(), that.getPartNumber());
    }

    public boolean equals(Object that) {
        if (this == that) {
            return true;
        }
        if (that == null || this.getClass() != that.getClass()) {
            return false;
        }
        MantaMultipartUploadTuple tuple = (MantaMultipartUploadTuple)that;
        return this.partNumber == tuple.partNumber && Objects.equals(this.etag, tuple.etag);
    }

    public int hashCode() {
        return Objects.hash(this.partNumber, this.etag);
    }

    public String toString() {
        return new ToStringBuilder((Object)this).append("partNumber", this.partNumber).append("etag", (Object)this.etag).toString();
    }
}

