/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.openstack;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.features.Location;
import ch.cyberduck.core.openstack.SwiftLocationFeature;
import ch.cyberduck.core.openstack.SwiftSession;
import ch.iterate.openstack.swift.Client;
import ch.iterate.openstack.swift.model.Region;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;

public class SwiftRegionService {
    private static final Logger log = Logger.getLogger(SwiftRegionService.class);
    private final SwiftSession session;
    private final PathContainerService containerService = new PathContainerService();
    private final SwiftLocationFeature location;

    public SwiftRegionService(SwiftSession session) {
        this(session, new SwiftLocationFeature(session));
    }

    public SwiftRegionService(SwiftSession session, SwiftLocationFeature location) {
        this.session = session;
        this.location = location;
    }

    public Region lookup(Path file) throws BackgroundException {
        Path container = this.containerService.getContainer(file);
        if (Location.unknown.equals((Object)new SwiftLocationFeature.SwiftRegion(container.attributes().getRegion()))) {
            return this.lookup(this.location.getLocation(container));
        }
        return this.lookup(new SwiftLocationFeature.SwiftRegion(file.attributes().getRegion()));
    }

    public Region lookup(Location.Name location) throws InteroperabilityException {
        if (!this.session.isConnected()) {
            log.warn((Object)"Cannot determine region if not connected");
            return new Region(location.getIdentifier(), null, null);
        }
        for (Region region : ((Client)this.session.getClient()).getRegions()) {
            if (StringUtils.isBlank((CharSequence)region.getRegionId()) || !region.getRegionId().equals(location.getIdentifier())) continue;
            return region;
        }
        log.warn((Object)String.format("Unknown region %s in authentication context", location));
        if (((Client)this.session.getClient()).getRegions().isEmpty()) {
            throw new InteroperabilityException("No region found in authentication context");
        }
        for (Region region : ((Client)this.session.getClient()).getRegions()) {
            if (!region.isDefault()) continue;
            log.warn((Object)String.format("Fallback to default region %s", region.getRegionId()));
            return region;
        }
        Region region = (Region)((Client)this.session.getClient()).getRegions().iterator().next();
        log.warn((Object)String.format("Fallback to first region %s", region.getRegionId()));
        if (null == region.getStorageUrl()) {
            throw new InteroperabilityException(String.format("No storage endpoint found for region %s", region.getRegionId()));
        }
        if (null == region.getCDNManagementUrl()) {
            log.warn((Object)String.format("No CDN management endpoint found for region %s", region.getRegionId()));
        }
        return region;
    }
}

