/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import java.util.Iterator;
import java.util.Objects;
import org.nuxeo.onedrive.client.JsonObjectIterator;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveDrive;
import org.nuxeo.onedrive.client.OneDriveResource;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;
import org.nuxeo.onedrive.client.URLTemplate;

public class OneDriveDrivesIterator
implements Iterator<OneDriveResource.Metadata> {
    private static final URLTemplate DRIVE_LIST_URL = new URLTemplate("/drives");
    private final OneDriveAPI api;
    private final JsonObjectIterator jsonObjectIterator;

    public OneDriveDrivesIterator(OneDriveAPI api) {
        this.api = Objects.requireNonNull(api);
        this.jsonObjectIterator = new JsonObjectIterator(api, DRIVE_LIST_URL.build(api.getBaseURL())){

            @Override
            protected void onResponse(JsonObject response) {
                OneDriveDrivesIterator.this.onResponse(response);
            }
        };
    }

    @Override
    public boolean hasNext() throws OneDriveRuntimeException {
        return this.jsonObjectIterator.hasNext();
    }

    @Override
    public OneDriveDrive.Metadata next() throws OneDriveRuntimeException {
        JsonObject nextObject = this.jsonObjectIterator.next();
        String id = nextObject.get("id").asString();
        if (nextObject.get("driveType") != null && !nextObject.get("driveType").isNull()) {
            OneDriveDrive drive;
            OneDriveDrive oneDriveDrive = drive = new OneDriveDrive(this.api, id);
            oneDriveDrive.getClass();
            return oneDriveDrive.new OneDriveDrive.Metadata(nextObject);
        }
        throw new OneDriveRuntimeException(new OneDriveAPIException("The object type is currently not handled"));
    }

    protected void onResponse(JsonObject response) {
    }
}

