/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.dav;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.dav.DAVClient;
import ch.cyberduck.core.dav.DAVExceptionMappingService;
import ch.cyberduck.core.dav.DAVPathEncoder;
import ch.cyberduck.core.dav.DAVSession;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Lock;
import com.github.sardine.impl.SardineException;
import java.io.IOException;

public class DAVLockFeature
implements Lock<String> {
    private final DAVSession session;

    public DAVLockFeature(DAVSession session) {
        this.session = session;
    }

    public String lock(Path file) throws BackgroundException {
        try {
            return ((DAVClient)((Object)this.session.getClient())).lock(new DAVPathEncoder().encode(file));
        }
        catch (SardineException e) {
            throw new DAVExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e, file);
        }
    }

    public void unlock(Path file, String token) throws BackgroundException {
        try {
            ((DAVClient)((Object)this.session.getClient())).unlock(new DAVPathEncoder().encode(file), token);
        }
        catch (SardineException e) {
            throw new DAVExceptionMappingService().map("Failure to write attributes of {0}", e, file);
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e, file);
        }
    }
}

