/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds.io.swagger.client.model;

import ch.cyberduck.core.sds.io.swagger.client.model.ObjectExpiration;
import ch.cyberduck.core.sds.io.swagger.client.model.UserAuthMethod;
import com.fasterxml.jackson.annotation.JsonCreator;
import com.fasterxml.jackson.annotation.JsonProperty;
import com.fasterxml.jackson.annotation.JsonValue;
import io.swagger.annotations.ApiModelProperty;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;

public class UpdateUserRequest {
    @JsonProperty(value="title")
    private String title = null;
    @JsonProperty(value="firstName")
    private String firstName = null;
    @JsonProperty(value="lastName")
    private String lastName = null;
    @JsonProperty(value="gender")
    private GenderEnum gender = null;
    @JsonProperty(value="email")
    private String email = null;
    @JsonProperty(value="lockStatus")
    private Integer lockStatus = null;
    @JsonProperty(value="expiration")
    private ObjectExpiration expiration = null;
    @JsonProperty(value="authMethods")
    private List<UserAuthMethod> authMethods = null;

    public UpdateUserRequest title(String title) {
        this.title = title;
        return this;
    }

    @ApiModelProperty(value="Job title")
    public String getTitle() {
        return this.title;
    }

    public void setTitle(String title) {
        this.title = title;
    }

    public UpdateUserRequest firstName(String firstName) {
        this.firstName = firstName;
        return this;
    }

    @ApiModelProperty(value="First name")
    public String getFirstName() {
        return this.firstName;
    }

    public void setFirstName(String firstName) {
        this.firstName = firstName;
    }

    public UpdateUserRequest lastName(String lastName) {
        this.lastName = lastName;
        return this;
    }

    @ApiModelProperty(value="Last name")
    public String getLastName() {
        return this.lastName;
    }

    public void setLastName(String lastName) {
        this.lastName = lastName;
    }

    public UpdateUserRequest gender(GenderEnum gender) {
        this.gender = gender;
        return this;
    }

    @ApiModelProperty(value="Gender key, one of [m|f|n]")
    public GenderEnum getGender() {
        return this.gender;
    }

    public void setGender(GenderEnum gender) {
        this.gender = gender;
    }

    public UpdateUserRequest email(String email) {
        this.email = email;
        return this;
    }

    @ApiModelProperty(value="Email [NOT USED]")
    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public UpdateUserRequest lockStatus(Integer lockStatus) {
        this.lockStatus = lockStatus;
        return this;
    }

    @ApiModelProperty(value="Lock status: 0 - Locked, 1 - Web access allowed, 2 - Web and mobile access allowed")
    public Integer getLockStatus() {
        return this.lockStatus;
    }

    public void setLockStatus(Integer lockStatus) {
        this.lockStatus = lockStatus;
    }

    public UpdateUserRequest expiration(ObjectExpiration expiration) {
        this.expiration = expiration;
        return this;
    }

    @ApiModelProperty(value="User expiration. <b>For a user with last role, no expiration date can be set</b>")
    public ObjectExpiration getExpiration() {
        return this.expiration;
    }

    public void setExpiration(ObjectExpiration expiration) {
        this.expiration = expiration;
    }

    public UpdateUserRequest authMethods(List<UserAuthMethod> authMethods) {
        this.authMethods = authMethods;
        return this;
    }

    public UpdateUserRequest addAuthMethodsItem(UserAuthMethod authMethodsItem) {
        if (this.authMethods == null) {
            this.authMethods = new ArrayList<UserAuthMethod>();
        }
        this.authMethods.add(authMethodsItem);
        return this;
    }

    @ApiModelProperty(value="Authentication methods")
    public List<UserAuthMethod> getAuthMethods() {
        return this.authMethods;
    }

    public void setAuthMethods(List<UserAuthMethod> authMethods) {
        this.authMethods = authMethods;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        UpdateUserRequest updateUserRequest = (UpdateUserRequest)o;
        return Objects.equals(this.title, updateUserRequest.title) && Objects.equals(this.firstName, updateUserRequest.firstName) && Objects.equals(this.lastName, updateUserRequest.lastName) && Objects.equals((Object)this.gender, (Object)updateUserRequest.gender) && Objects.equals(this.email, updateUserRequest.email) && Objects.equals(this.lockStatus, updateUserRequest.lockStatus) && Objects.equals(this.expiration, updateUserRequest.expiration) && Objects.equals(this.authMethods, updateUserRequest.authMethods);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.title, this.firstName, this.lastName, this.gender, this.email, this.lockStatus, this.expiration, this.authMethods});
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        sb.append("class UpdateUserRequest {\n");
        sb.append("    title: ").append(this.toIndentedString(this.title)).append("\n");
        sb.append("    firstName: ").append(this.toIndentedString(this.firstName)).append("\n");
        sb.append("    lastName: ").append(this.toIndentedString(this.lastName)).append("\n");
        sb.append("    gender: ").append(this.toIndentedString((Object)this.gender)).append("\n");
        sb.append("    email: ").append(this.toIndentedString(this.email)).append("\n");
        sb.append("    lockStatus: ").append(this.toIndentedString(this.lockStatus)).append("\n");
        sb.append("    expiration: ").append(this.toIndentedString(this.expiration)).append("\n");
        sb.append("    authMethods: ").append(this.toIndentedString(this.authMethods)).append("\n");
        sb.append("}");
        return sb.toString();
    }

    private String toIndentedString(Object o) {
        if (o == null) {
            return "null";
        }
        return o.toString().replace("\n", "\n    ");
    }

    public static enum GenderEnum {
        M("m"),
        F("f"),
        N("n");

        private String value;

        private GenderEnum(String value) {
            this.value = value;
        }

        @JsonValue
        public String getValue() {
            return this.value;
        }

        public String toString() {
            return String.valueOf(this.value);
        }

        @JsonCreator
        public static GenderEnum fromValue(String text) {
            for (GenderEnum b : GenderEnum.values()) {
                if (!String.valueOf(b.value).equals(text)) continue;
                return b;
            }
            return null;
        }
    }
}

