/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.sds;

import ch.cyberduck.core.Acl;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.io.Checksum;
import ch.cyberduck.core.sds.SDSExceptionMappingService;
import ch.cyberduck.core.sds.SDSNodeIdProvider;
import ch.cyberduck.core.sds.SDSPermissionsFeature;
import ch.cyberduck.core.sds.SDSSession;
import ch.cyberduck.core.sds.io.swagger.client.ApiClient;
import ch.cyberduck.core.sds.io.swagger.client.ApiException;
import ch.cyberduck.core.sds.io.swagger.client.api.NodesApi;
import ch.cyberduck.core.sds.io.swagger.client.model.Node;

public class SDSAttributesFinderFeature
implements AttributesFinder {
    public static final String KEY_CNT_DOWNLOADSHARES = "count_downloadshares";
    public static final String KEY_CNT_UPLOADSHARES = "count_uploadshares";
    public static final String KEY_BRANCHVERSION = "branch_version";
    private final SDSSession session;
    private final SDSNodeIdProvider nodeid;
    private Cache<Path> cache = PathCache.empty();

    public SDSAttributesFinderFeature(SDSSession session, SDSNodeIdProvider nodeid) {
        this.session = session;
        this.nodeid = nodeid;
    }

    public PathAttributes find(Path file) throws BackgroundException {
        try {
            Node node = new NodesApi((ApiClient)this.session.getClient()).getFsNode("", Long.parseLong(this.nodeid.withCache((Cache)this.cache).getFileid(file, (ListProgressListener)new DisabledListProgressListener())), null);
            return this.toAttributes(node);
        }
        catch (ApiException e) {
            throw new SDSExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
    }

    public PathAttributes toAttributes(Node node) throws BackgroundException {
        PathAttributes attributes = new PathAttributes();
        attributes.setVersionId(String.valueOf(node.getId()));
        attributes.setChecksum(Checksum.parse((String)node.getHash()));
        attributes.setCreationDate(node.getCreatedAt() != null ? node.getCreatedAt().getTime() : -1L);
        attributes.setModificationDate(node.getUpdatedAt() != null ? node.getUpdatedAt().getTime() : -1L);
        attributes.setSize(node.getSize().longValue());
        attributes.setPermission(this.toPermission(node));
        attributes.setAcl(this.toAcl(node));
        return attributes;
    }

    private Permission toPermission(Node node) {
        Permission permission = new Permission(Permission.Action.read, Permission.Action.none, Permission.Action.none);
        switch (node.getType()) {
            case ROOM: 
            case FOLDER: {
                permission.setUser(permission.getUser().or(Permission.Action.execute));
            }
        }
        if (node.getPermissions().getChange().booleanValue()) {
            permission.setUser(permission.getUser().or(Permission.Action.write));
        }
        return permission;
    }

    private Acl toAcl(Node node) throws BackgroundException {
        Acl acl = new Acl();
        Acl.CanonicalUser user = new Acl.CanonicalUser(String.valueOf(this.session.userAccount().getId()));
        if (node.getPermissions().getManage().booleanValue()) {
            acl.addAll((Acl.User)user, new Acl.Role[]{SDSPermissionsFeature.MANAGE_ROLE});
        }
        if (node.getPermissions().getRead().booleanValue()) {
            acl.addAll((Acl.User)user, new Acl.Role[]{SDSPermissionsFeature.READ_ROLE});
        }
        if (node.getPermissions().getCreate().booleanValue()) {
            acl.addAll((Acl.User)user, new Acl.Role[]{SDSPermissionsFeature.CREATE_ROLE});
        }
        if (node.getPermissions().getChange().booleanValue()) {
            acl.addAll((Acl.User)user, new Acl.Role[]{SDSPermissionsFeature.CHANGE_ROLE});
        }
        if (node.getPermissions().getDelete().booleanValue()) {
            acl.addAll((Acl.User)user, new Acl.Role[]{SDSPermissionsFeature.DELETE_ROLE});
        }
        if (node.getPermissions().getManageDownloadShare().booleanValue()) {
            acl.addAll((Acl.User)user, new Acl.Role[]{SDSPermissionsFeature.DOWNLOAD_SHARE_ROLE});
        }
        if (node.getPermissions().getManageUploadShare().booleanValue()) {
            acl.addAll((Acl.User)user, new Acl.Role[]{SDSPermissionsFeature.UPLOAD_SHARE_ROLE});
        }
        return acl;
    }

    public AttributesFinder withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }
}

