/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.DefaultIOExceptionMappingService;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.UrlProvider;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Copy;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Directory;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Home;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.features.MultipartWrite;
import ch.cyberduck.core.features.PromptUrlProvider;
import ch.cyberduck.core.features.Quota;
import ch.cyberduck.core.features.Read;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.features.Timestamp;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.http.HttpSession;
import ch.cyberduck.core.oauth.OAuth2ErrorResponseInterceptor;
import ch.cyberduck.core.oauth.OAuth2RequestInterceptor;
import ch.cyberduck.core.onedrive.OneDriveAttributesFinderFeature;
import ch.cyberduck.core.onedrive.OneDriveBufferWriteFeature;
import ch.cyberduck.core.onedrive.OneDriveCommonsHttpRequestExecutor;
import ch.cyberduck.core.onedrive.OneDriveCopyFeature;
import ch.cyberduck.core.onedrive.OneDriveDeleteFeature;
import ch.cyberduck.core.onedrive.OneDriveDirectoryFeature;
import ch.cyberduck.core.onedrive.OneDriveFindFeature;
import ch.cyberduck.core.onedrive.OneDriveHomeFinderFeature;
import ch.cyberduck.core.onedrive.OneDriveListService;
import ch.cyberduck.core.onedrive.OneDriveMoveFeature;
import ch.cyberduck.core.onedrive.OneDriveQuotaFeature;
import ch.cyberduck.core.onedrive.OneDriveReadFeature;
import ch.cyberduck.core.onedrive.OneDriveSearchFeature;
import ch.cyberduck.core.onedrive.OneDriveSharingLinkUrlProvider;
import ch.cyberduck.core.onedrive.OneDriveTimestampFeature;
import ch.cyberduck.core.onedrive.OneDriveTouchFeature;
import ch.cyberduck.core.onedrive.OneDriveUrlProvider;
import ch.cyberduck.core.onedrive.OneDriveWriteFeature;
import ch.cyberduck.core.proxy.Proxy;
import ch.cyberduck.core.ssl.ThreadLocalHostnameDelegatingTrustManager;
import ch.cyberduck.core.ssl.X509KeyManager;
import ch.cyberduck.core.ssl.X509TrustManager;
import ch.cyberduck.core.threading.CancelCallback;
import java.io.IOException;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ServiceUnavailableRetryStrategy;
import org.apache.http.impl.client.HttpClientBuilder;
import org.apache.http.protocol.HttpContext;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveDrive;
import org.nuxeo.onedrive.client.OneDriveFile;
import org.nuxeo.onedrive.client.OneDriveFolder;
import org.nuxeo.onedrive.client.RequestExecutor;
import org.nuxeo.onedrive.client.RequestHeader;

public class OneDriveSession
extends HttpSession<OneDriveAPI> {
    private final PathContainerService containerService = new PathContainerService();
    private OAuth2RequestInterceptor authorizationService;

    public OneDriveSession(Host host, X509TrustManager trust, X509KeyManager key) {
        super(host, new ThreadLocalHostnameDelegatingTrustManager(trust, host.getHostname()), key);
    }

    public OneDriveFile toFile(Path file) {
        return new OneDriveFile((OneDriveAPI)this.client, new OneDriveDrive((OneDriveAPI)this.client, this.containerService.getContainer(file).getName()), URIEncoder.encode((String)this.containerService.getKey(file)));
    }

    public OneDriveFolder toFolder(Path file) {
        if (file.isRoot()) {
            return OneDriveFolder.getRoot((OneDriveAPI)((OneDriveAPI)this.client));
        }
        if (this.containerService.isContainer(file)) {
            return new OneDriveDrive((OneDriveAPI)this.client, this.containerService.getContainer(file).getName()).getRoot();
        }
        return new OneDriveFolder((OneDriveAPI)this.client, new OneDriveDrive((OneDriveAPI)this.client, this.containerService.getContainer(file).getName()), URIEncoder.encode((String)this.containerService.getKey(file)));
    }

    protected OneDriveAPI connect(Proxy proxy, HostKeyCallback key, LoginCallback prompt) {
        this.authorizationService = new OAuth2RequestInterceptor((HttpClient)this.builder.build(proxy, (TranscriptListener)this, prompt).build(), this.host.getProtocol()){

            public void process(HttpRequest request, HttpContext context) throws HttpException, IOException {
                if (request.containsHeader("Authorization")) {
                    super.process(request, context);
                }
            }
        }.withRedirectUri(this.host.getProtocol().getOAuthRedirectUrl());
        HttpClientBuilder configuration = this.builder.build(proxy, (TranscriptListener)this, prompt);
        configuration.addInterceptorLast((HttpRequestInterceptor)this.authorizationService);
        configuration.setServiceUnavailableRetryStrategy((ServiceUnavailableRetryStrategy)new OAuth2ErrorResponseInterceptor(this.authorizationService));
        final OneDriveCommonsHttpRequestExecutor executor = new OneDriveCommonsHttpRequestExecutor(configuration.build()){

            public void addAuthorizationHeader(Set<RequestHeader> headers) {
                headers.add(new RequestHeader("Authorization", "Bearer"));
            }
        };
        return new OneDriveAPI(){

            public RequestExecutor getExecutor() {
                return executor;
            }

            public boolean isBusinessConnection() {
                return false;
            }

            public boolean isGraphConnection() {
                return StringUtils.equals((CharSequence)"graph.microsoft.com", (CharSequence)OneDriveSession.this.host.getHostname());
            }

            public String getBaseURL() {
                return String.format("%s://%s%s", OneDriveSession.this.host.getProtocol().getScheme(), OneDriveSession.this.host.getHostname(), OneDriveSession.this.host.getProtocol().getContext());
            }

            public String getEmailURL() {
                return null;
            }
        };
    }

    public void login(Proxy proxy, HostPasswordStore keychain, LoginCallback prompt, CancelCallback cancel) throws BackgroundException {
        this.authorizationService.setTokens(this.authorizationService.authorize(this.host, keychain, prompt, cancel));
    }

    protected void logout() throws BackgroundException {
        try {
            ((OneDriveAPI)this.client).getExecutor().close();
        }
        catch (IOException e) {
            throw new DefaultIOExceptionMappingService().map(e);
        }
    }

    public <T> T _getFeature(Class<T> type) {
        if (type == ListService.class) {
            return (T)new OneDriveListService(this);
        }
        if (type == Directory.class) {
            return (T)new OneDriveDirectoryFeature(this);
        }
        if (type == Read.class) {
            return (T)new OneDriveReadFeature(this);
        }
        if (type == Write.class) {
            return (T)new OneDriveWriteFeature(this);
        }
        if (type == MultipartWrite.class) {
            return (T)new OneDriveBufferWriteFeature(this);
        }
        if (type == Delete.class) {
            return (T)new OneDriveDeleteFeature(this);
        }
        if (type == Touch.class) {
            return (T)new OneDriveTouchFeature(this);
        }
        if (type == Move.class) {
            return (T)new OneDriveMoveFeature(this);
        }
        if (type == Copy.class) {
            return (T)new OneDriveCopyFeature(this);
        }
        if (type == Find.class) {
            return (T)new OneDriveFindFeature(this);
        }
        if (type == AttributesFinder.class) {
            return (T)new OneDriveAttributesFinderFeature(this);
        }
        if (type == UrlProvider.class) {
            return (T)new OneDriveUrlProvider();
        }
        if (type == PromptUrlProvider.class) {
            return (T)new OneDriveSharingLinkUrlProvider(this);
        }
        if (type == Home.class) {
            return (T)((Object)new OneDriveHomeFinderFeature(this));
        }
        if (type == Quota.class) {
            return (T)new OneDriveQuotaFeature(this);
        }
        if (type == Search.class) {
            return (T)new OneDriveSearchFeature(this);
        }
        if (type == Timestamp.class) {
            return (T)((Object)new OneDriveTimestampFeature(this));
        }
        return (T)super._getFeature(type);
    }
}

