/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.onedrive;

import ch.cyberduck.core.AbstractPath;
import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Filter;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.Referenceable;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Search;
import ch.cyberduck.core.onedrive.OneDriveAttributesFinderFeature;
import ch.cyberduck.core.onedrive.OneDriveSession;
import java.util.EnumSet;
import java.util.Iterator;
import org.apache.commons.lang3.StringUtils;
import org.apache.log4j.Logger;
import org.nuxeo.onedrive.client.OneDriveExpand;
import org.nuxeo.onedrive.client.OneDriveItem;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;

public class OneDriveSearchFeature
implements Search {
    private static final Logger log = Logger.getLogger(OneDriveSearchFeature.class);
    private final OneDriveSession session;
    private final OneDriveAttributesFinderFeature attributes;

    public OneDriveSearchFeature(OneDriveSession session) {
        this.session = session;
        this.attributes = new OneDriveAttributesFinderFeature(session);
    }

    public AttributedList<Path> search(Path workdir, Filter<Path> regex, ListProgressListener listener) throws BackgroundException {
        AttributedList list = new AttributedList();
        Iterator iterator = this.session.toFolder(workdir).search(regex.toPattern().pattern(), new OneDriveExpand[0]).iterator();
        while (iterator.hasNext()) {
            OneDriveItem.Metadata metadata;
            try {
                metadata = (OneDriveItem.Metadata)iterator.next();
            }
            catch (OneDriveRuntimeException e) {
                log.warn((Object)e);
                continue;
            }
            list.add((Referenceable)new Path(String.format("/%s/%s/%s", metadata.getParentReference().getDriveId(), StringUtils.removeStart((String)metadata.getParentReference().getPath(), (String)"/drive/root:"), metadata.getName()), metadata.isFolder() ? EnumSet.of(AbstractPath.Type.directory) : EnumSet.of(AbstractPath.Type.file), this.attributes.convert(metadata)));
        }
        return list;
    }

    public boolean isRecursive() {
        return true;
    }

    public Search withCache(Cache<Path> cache) {
        return this;
    }
}

