/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import java.util.Objects;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveDrive;
import org.nuxeo.onedrive.client.OneDriveJsonObject;

public class OneDriveResource {
    private final OneDriveAPI api;
    private final String resourceIdentifier;
    private final OneDriveDrive resourceDrive;
    private final ResourceIdentifierType resourceIdentifierType;

    public OneDriveResource(OneDriveAPI api, String id) {
        this(api, id, ResourceIdentifierType.Id);
    }

    public OneDriveResource(OneDriveAPI api, OneDriveDrive drive, String path) {
        this(api, drive, path, ResourceIdentifierType.Path);
    }

    OneDriveResource(OneDriveAPI api) {
        this.api = Objects.requireNonNull(api);
        this.resourceDrive = null;
        this.resourceIdentifier = null;
        this.resourceIdentifierType = ResourceIdentifierType.Path;
    }

    OneDriveResource(OneDriveAPI api, OneDriveDrive drive) {
        this.api = Objects.requireNonNull(api);
        this.resourceDrive = Objects.requireNonNull(drive);
        this.resourceIdentifier = null;
        this.resourceIdentifierType = ResourceIdentifierType.Path;
    }

    public OneDriveResource(OneDriveAPI api, String resourceIdentifier, ResourceIdentifierType resourceIdentifierType) {
        this.api = Objects.requireNonNull(api);
        this.resourceIdentifier = Objects.requireNonNull(resourceIdentifier);
        this.resourceIdentifierType = resourceIdentifierType;
        this.resourceDrive = null;
    }

    public OneDriveResource(OneDriveAPI api, OneDriveDrive drive, String resourceIdentifier, ResourceIdentifierType resourceIdentifierType) {
        this.api = Objects.requireNonNull(api);
        this.resourceDrive = Objects.requireNonNull(drive);
        this.resourceIdentifier = Objects.requireNonNull(resourceIdentifier);
        this.resourceIdentifierType = resourceIdentifierType;
    }

    public OneDriveAPI getApi() {
        return this.api;
    }

    public boolean isRoot() {
        return this.resourceIdentifier == null;
    }

    public String getResourceIdentifier() {
        return this.resourceIdentifier;
    }

    public OneDriveDrive getResourceDrive() {
        return this.resourceDrive;
    }

    public ResourceIdentifierType getResourceIdentifierType() {
        return this.resourceIdentifierType;
    }

    public boolean equals(Object obj) {
        if (obj == null || !this.getClass().equals(obj.getClass())) {
            return false;
        }
        if (this == obj) {
            return true;
        }
        OneDriveResource oDObj = (OneDriveResource)obj;
        return this.getResourceIdentifier().equals(oDObj.getResourceIdentifier());
    }

    public int hashCode() {
        return this.getResourceIdentifier().hashCode();
    }

    public abstract class Metadata
    extends OneDriveJsonObject {
        public Metadata(JsonObject json) {
            super(json);
        }

        public String getId() {
            return OneDriveResource.this.getResourceIdentifier();
        }

        public abstract OneDriveResource getResource();
    }

    public static enum ResourceIdentifierType {
        Id,
        Path;

    }
}

