/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.ParseException;
import java.util.Objects;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveFolder;
import org.nuxeo.onedrive.client.OneDriveIdentitySet;
import org.nuxeo.onedrive.client.OneDriveResource;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;
import org.nuxeo.onedrive.client.OneDriveSharingLink;
import org.nuxeo.onedrive.client.URLTemplate;

public class OneDrivePermission
extends OneDriveResource {
    private static final URLTemplate PERMISSIONS_URL = new URLTemplate("/drive/items/%s/permissions/%s");
    private static final URLTemplate PERMISSIONS_ROOT_URL = new URLTemplate("/drive/root/permissions/%s");
    private final String itemId;
    private final String permissionId;

    OneDrivePermission(OneDriveAPI api, String permissionId) {
        super(api, "root$$" + permissionId);
        this.itemId = null;
        this.permissionId = Objects.requireNonNull(permissionId);
    }

    public OneDrivePermission(OneDriveAPI api, String itemId, String permissionId) {
        super(api, itemId + "$$" + permissionId);
        this.itemId = Objects.requireNonNull(itemId);
        this.permissionId = Objects.requireNonNull(permissionId);
    }

    public class Metadata
    extends OneDriveResource.Metadata {
        private boolean writable;
        private OneDriveSharingLink link;
        private OneDriveIdentitySet grantedTo;
        private OneDriveFolder.Reference inheritedFrom;
        private String shareId;

        public Metadata(JsonObject json) {
            super(OneDrivePermission.this, json);
        }

        public boolean isWritable() {
            return this.writable;
        }

        public OneDriveSharingLink getLink() {
            return this.link;
        }

        public OneDriveIdentitySet getGrantedTo() {
            return this.grantedTo;
        }

        public OneDriveFolder.Reference getInheritedFrom() {
            return this.inheritedFrom;
        }

        public String getShareId() {
            return this.shareId;
        }

        @Override
        protected void parseMember(JsonObject.Member member) {
            super.parseMember(member);
            try {
                JsonValue value = member.getValue();
                String memberName = member.getName();
                if ("roles".equals(memberName)) {
                    this.writable = value.asArray().values().stream().filter(JsonValue::isString).map(JsonValue::asString).anyMatch("write"::equalsIgnoreCase);
                } else if ("link".equals(memberName)) {
                    this.link = new OneDriveSharingLink(value.asObject());
                } else if ("grantedTo".equals(memberName)) {
                    this.grantedTo = new OneDriveIdentitySet(value.asObject());
                } else if ("inheritedFrom".equals(memberName)) {
                    OneDriveFolder inheritedFromFolder;
                    JsonObject valueObject = value.asObject();
                    String id = valueObject.get("id").asString();
                    OneDriveFolder oneDriveFolder = inheritedFromFolder = new OneDriveFolder(OneDrivePermission.this.getApi(), id);
                    oneDriveFolder.getClass();
                    this.inheritedFrom = new OneDriveFolder.Reference(oneDriveFolder, valueObject);
                } else if ("shareId".equals(memberName)) {
                    this.shareId = value.asString();
                }
            }
            catch (ParseException e) {
                throw new OneDriveRuntimeException(new OneDriveAPIException(e.getMessage(), e));
            }
        }

        @Override
        public OneDrivePermission getResource() {
            return OneDrivePermission.this;
        }
    }
}

