/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.cli;

import ch.cyberduck.cli.TerminalHelpFormatter;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.LocalFactory;
import ch.cyberduck.core.Protocol;
import ch.cyberduck.core.ProtocolFactory;
import ch.cyberduck.core.aquaticprime.DisabledLicenseVerifierCallback;
import ch.cyberduck.core.aquaticprime.License;
import ch.cyberduck.core.aquaticprime.LicenseFactory;
import ch.cyberduck.core.preferences.Preferences;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.preferences.SupportDirectoryFinderFactory;
import java.text.MessageFormat;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Options;

public final class TerminalHelpPrinter {
    private TerminalHelpPrinter() {
    }

    public static void print(Options options) {
        TerminalHelpPrinter.print(options, new TerminalHelpFormatter());
    }

    public static void print(Options options, HelpFormatter formatter) {
        formatter.setSyntaxPrefix("Usage:");
        StringBuilder protocols = new StringBuilder("\n");
        protocols.append("Supported protocols");
        protocols.append("\n");
        for (Protocol p : ProtocolFactory.get().find()) {
            protocols.append(p.getDescription());
            protocols.append("\n");
            switch (p.getType()) {
                case b2: 
                case s3: 
                case googlestorage: 
                case swift: 
                case azure: {
                    protocols.append("\t").append(String.format("%s://<container>/<key>", p.isBundled() ? p.getIdentifier() : p.getProvider()));
                    break;
                }
                default: {
                    if (p.isHostnameConfigurable()) {
                        protocols.append("\t").append(String.format("%s://<hostname>/<folder>/<file>", p.isBundled() ? p.getIdentifier() : p.getProvider()));
                        break;
                    }
                    protocols.append("\t").append(String.format("%s://<folder>/<file>", p.isBundled() ? p.getIdentifier() : p.getProvider()));
                }
            }
            protocols.append("\n");
        }
        StringBuilder header = new StringBuilder("\n");
        header.append("\t");
        header.append("URLs must be fully qualified. Paths can either denote a remote file (ftps://user@example.net/resource) or folder (ftps://user@example.net/directory/) with a trailing slash. You can reference files relative to your home directory with /~ (ftps://user@example.net/~/).");
        header.append(protocols.toString());
        Preferences preferences = PreferencesFactory.get();
        Local profiles = LocalFactory.get(SupportDirectoryFinderFactory.get().find(), PreferencesFactory.get().getProperty("profiles.folder.name"));
        header.append("\n");
        header.append(String.format("You can install additional connection profiles in %s", profiles.getAbbreviatedPath()));
        header.append("\n");
        StringBuilder footer = new StringBuilder("\n");
        footer.append(String.format("Cyberduck is libre software licenced under the GPL. For general help about using Cyberduck, please refer to %s and the wiki at %s. For bug reports or feature requests open a ticket at %s.", preferences.getProperty("website.cli"), preferences.getProperty("website.help"), MessageFormat.format(preferences.getProperty("website.bug"), preferences.getProperty("application.version"))));
        License l = LicenseFactory.find();
        footer.append("\n");
        if (l.verify(new DisabledLicenseVerifierCallback())) {
            footer.append(l.toString());
        } else {
            footer.append("Not registered. Purchase a donation key to support the development of this software.");
        }
        formatter.printHelp("duck [options...]", header.toString(), options, footer.toString());
    }
}

