/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.cli;

import ch.cyberduck.cli.CommandLinePathParser;
import ch.cyberduck.cli.TerminalOptionsBuilder;
import ch.cyberduck.core.Host;
import ch.cyberduck.core.HostParser;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProtocolFactory;
import org.apache.commons.cli.CommandLine;

public class CommandLineUriParser {
    private final CommandLine input;
    private final ProtocolFactory factory;

    public CommandLineUriParser(CommandLine input) {
        this(input, ProtocolFactory.get());
    }

    public CommandLineUriParser(CommandLine input, ProtocolFactory factory) {
        this.input = input;
        this.factory = factory;
    }

    public Host parse(String uri) {
        Path directory;
        Host host = new HostParser(this.factory).get(uri);
        if (this.input.hasOption(TerminalOptionsBuilder.Params.region.name())) {
            host.setRegion(this.input.getOptionValue(TerminalOptionsBuilder.Params.region.name()));
        }
        if ((directory = new CommandLinePathParser(this.input, this.factory).parse(uri)).isDirectory()) {
            host.setDefaultPath(directory.getAbsolute());
        } else {
            host.setDefaultPath(directory.getParent().getAbsolute());
        }
        if (this.input.hasOption(TerminalOptionsBuilder.Params.udt.name())) {
            host.setTransfer(Host.TransferType.udt);
        }
        return host;
    }
}

