/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.cryptomator.CryptoVault;
import ch.cyberduck.core.cryptomator.features.CryptoWriteFeature;
import ch.cyberduck.core.cryptomator.random.RandomNonceGenerator;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.random.NonceGenerator;
import ch.cyberduck.core.transfer.TransferStatus;
import org.cryptomator.cryptolib.api.Cryptor;
import org.cryptomator.cryptolib.api.FileHeader;

public class CryptoTouchFeature<Reply>
implements Touch<Reply> {
    private final Session<?> session;
    private final Touch<Reply> proxy;
    private final CryptoVault vault;

    public CryptoTouchFeature(Session<?> session, Touch<Reply> proxy, Write<Reply> writer, CryptoVault cryptomator) {
        this.session = session;
        this.proxy = proxy.withWriter(new CryptoWriteFeature<Reply>(session, writer, cryptomator));
        this.vault = cryptomator;
    }

    public Path touch(Path file, TransferStatus status) throws BackgroundException {
        Cryptor cryptor = this.vault.getCryptor();
        FileHeader header = cryptor.fileHeaderCryptor().create();
        status.setHeader(cryptor.fileHeaderCryptor().encryptHeader(header));
        status.setNonces((NonceGenerator)new RandomNonceGenerator());
        Path target = this.proxy.touch(this.vault.encrypt(this.session, file), status);
        return this.vault.decrypt(this.session, target);
    }

    public boolean isSupported(Path workdir) {
        return this.proxy.isSupported(workdir);
    }

    public CryptoTouchFeature<Reply> withWriter(Write<Reply> writer) {
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoTouchFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

