/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.cryptomator.features;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.PathCache;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.cryptomator.CryptoPathCache;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.features.Vault;

public class CryptoAttributesFeature
implements AttributesFinder {
    private final Session<?> session;
    private final AttributesFinder delegate;
    private final Vault vault;
    private Cache<Path> cache = PathCache.empty();

    public CryptoAttributesFeature(Session<?> session, AttributesFinder delegate, Vault cryptomator) {
        this.session = session;
        this.delegate = delegate;
        this.vault = cryptomator;
    }

    public PathAttributes find(Path file) throws BackgroundException {
        PathAttributes attributes = this.delegate.withCache((Cache)new CryptoPathCache(this.cache)).find(this.vault.encrypt(this.session, file));
        if (file.isFile()) {
            attributes.setSize(this.vault.toCleartextSize(attributes.getSize()));
        }
        return attributes;
    }

    public AttributesFinder withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("CryptoAttributesFeature{");
        sb.append("delegate=").append(this.delegate);
        sb.append('}');
        return sb.toString();
    }
}

