/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.nio;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Permission;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.nio.LocalExceptionMappingService;
import ch.cyberduck.core.nio.LocalSession;
import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.LinkOption;
import java.nio.file.attribute.DosFileAttributes;
import java.nio.file.attribute.PosixFileAttributes;
import java.nio.file.attribute.PosixFilePermissions;

public class LocalAttributesFinderFeature
implements AttributesFinder {
    private final LocalSession session;

    public LocalAttributesFinderFeature(LocalSession session) {
        this.session = session;
    }

    public PathAttributes find(Path file) throws BackgroundException {
        try {
            return this.convert(this.session.toPath(file));
        }
        catch (IOException e) {
            throw new LocalExceptionMappingService().map("Failure to read attributes of {0}", e, file);
        }
    }

    public AttributesFinder withCache(Cache<Path> cache) {
        return this;
    }

    protected PathAttributes convert(java.nio.file.Path file) throws IOException {
        boolean isPosix = this.session.isPosixFilesystem();
        PathAttributes attributes = new PathAttributes();
        Class provider = isPosix ? PosixFileAttributes.class : DosFileAttributes.class;
        PosixFileAttributes a = Files.readAttributes(file, provider, LinkOption.NOFOLLOW_LINKS);
        if (Files.isRegularFile(file, new LinkOption[0])) {
            attributes.setSize(a.size());
        }
        attributes.setModificationDate(a.lastModifiedTime().toMillis());
        attributes.setCreationDate(a.creationTime().toMillis());
        attributes.setAccessedDate(a.lastAccessTime().toMillis());
        if (isPosix) {
            attributes.setOwner(a.owner().getName());
            attributes.setGroup(a.group().getName());
            attributes.setPermission(new Permission(PosixFilePermissions.toString(a.permissions())));
        } else {
            Permission.Action actions = Permission.Action.none;
            if (Files.isReadable(file)) {
                actions = actions.or(Permission.Action.read);
            }
            if (Files.isWritable(file)) {
                actions = actions.or(Permission.Action.write);
            }
            if (Files.isExecutable(file)) {
                actions = actions.or(Permission.Action.execute);
            }
            attributes.setPermission(new Permission(actions, Permission.Action.none, Permission.Action.none));
        }
        return attributes;
    }
}

