/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.googledrive;

import ch.cyberduck.core.AttributedList;
import ch.cyberduck.core.Cache;
import ch.cyberduck.core.DisabledListProgressListener;
import ch.cyberduck.core.ListProgressListener;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.SimplePathPredicate;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.NotfoundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.googledrive.DriveFileidProvider;
import ch.cyberduck.core.googledrive.DriveSession;
import ch.cyberduck.core.googledrive.FileidDriveListService;
import java.util.function.Predicate;

public class DriveAttributesFinderFeature
implements AttributesFinder {
    private final DriveSession session;
    private final DriveFileidProvider fileid;

    public DriveAttributesFinderFeature(DriveSession session, DriveFileidProvider fileid) {
        this.session = session;
        this.fileid = fileid;
    }

    public PathAttributes find(Path file) throws BackgroundException {
        AttributedList<Path> list = new FileidDriveListService(this.session, this.fileid, file).list(file.getParent(), (ListProgressListener)new DisabledListProgressListener());
        Path found = (Path)list.find((Predicate)new SimplePathPredicate(file));
        if (null == found) {
            throw new NotfoundException(file.getAbsolute());
        }
        return found.attributes();
    }

    public AttributesFinder withCache(Cache<Path> cache) {
        return this;
    }
}

