/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.s3;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathContainerService;
import ch.cyberduck.core.URIEncoder;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.InteroperabilityException;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.s3.RequestEntityRestStorageService;
import ch.cyberduck.core.s3.S3ExceptionMappingService;
import ch.cyberduck.core.s3.S3PathContainerService;
import ch.cyberduck.core.s3.S3Session;
import org.jets3t.service.ServiceException;
import org.jets3t.service.acl.AccessControlList;
import org.jets3t.service.utils.ServiceUtils;

public class S3BucketCreateService {
    private final S3Session session;
    private final PathContainerService containerService = new S3PathContainerService();

    public S3BucketCreateService(S3Session session) {
        this.session = session;
    }

    public void create(Path bucket, String location) throws BackgroundException {
        if (!this.session.configure().getBoolProperty("s3service.disable-dns-buckets", false) && !ServiceUtils.isBucketNameValidDNSName((String)bucket.getName())) {
            throw new InteroperabilityException(LocaleFactory.localizedString((String)"Bucket name is not DNS compatible", (String)"S3"));
        }
        AccessControlList acl = PreferencesFactory.get().getProperty("s3.bucket.acl.default").equals("public-read") ? AccessControlList.REST_CANNED_PUBLIC_READ : AccessControlList.REST_CANNED_PRIVATE;
        try {
            String region = "us-east-1".equals(location) ? "US" : location;
            ((RequestEntityRestStorageService)((Object)this.session.getClient())).createBucket(URIEncoder.encode((String)this.containerService.getContainer(bucket).getName()), region, acl);
        }
        catch (ServiceException e) {
            throw new S3ExceptionMappingService().map("Cannot create folder {0}", e, bucket);
        }
    }
}

