/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.worker;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.HostKeyCallback;
import ch.cyberduck.core.HostPasswordStore;
import ch.cyberduck.core.ListService;
import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.LoginCallback;
import ch.cyberduck.core.MappingMimeTypeService;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.SessionPoolFactory;
import ch.cyberduck.core.TranscriptListener;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.exception.ConnectionCanceledException;
import ch.cyberduck.core.features.Delete;
import ch.cyberduck.core.features.Find;
import ch.cyberduck.core.features.Move;
import ch.cyberduck.core.shared.DefaultFindFeature;
import ch.cyberduck.core.transfer.TransferStatus;
import ch.cyberduck.core.worker.CopyWorker;
import ch.cyberduck.core.worker.DeleteWorker;
import ch.cyberduck.core.worker.Worker;
import ch.cyberduck.core.worker.WorkerListProgressListener;
import java.text.MessageFormat;
import java.util.Collections;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;

public class MoveWorker
extends Worker<Map<Path, Path>> {
    private final Map<Path, Path> files;
    private final HostPasswordStore keychain;
    private final ProgressListener listener;
    private final Cache<Path> cache;
    private final LoginCallback callback;
    private final HostKeyCallback key;
    private final TranscriptListener transcript;

    public MoveWorker(Map<Path, Path> files, Cache<Path> cache, HostPasswordStore keychain, LoginCallback callback, HostKeyCallback key, ProgressListener listener, TranscriptListener transcript) {
        this.files = files;
        this.keychain = keychain;
        this.listener = listener;
        this.cache = cache;
        this.callback = callback;
        this.key = key;
        this.transcript = transcript;
    }

    @Override
    public Map<Path, Path> run(Session<?> session) throws BackgroundException {
        Move move = session.getFeature(Move.class);
        ListService list = session.getFeature(ListService.class);
        HashMap<Path, Path> result = new HashMap<Path, Path>();
        for (Map.Entry<Path, Path> entry : this.files.entrySet()) {
            if (this.isCanceled()) {
                throw new ConnectionCanceledException();
            }
            if (!move.isSupported(entry.getKey(), entry.getValue())) {
                Object copy = new CopyWorker(Collections.singletonMap(entry.getKey(), entry.getValue()), SessionPoolFactory.create(this.cache, session.getHost(), this.keychain, this.callback, this.key, this.listener, this.transcript, new SessionPoolFactory.Usage[0]), this.cache, this.listener, this.callback).run((Session)session);
                for (Map.Entry<Path, Path> r : this.files.entrySet()) {
                    new DeleteWorker(this.callback, Collections.singletonList(r.getKey()), this.cache, this.listener).run((Session)session);
                }
                result.putAll((Map<Path, Path>)copy);
                continue;
            }
            Map<Path, Path> recursive = this.compile(move, list, entry.getKey(), entry.getValue());
            for (Map.Entry<Path, Path> r : recursive.entrySet()) {
                TransferStatus status = new TransferStatus().withMime(new MappingMimeTypeService().getMime(r.getValue().getName())).exists(((Find)session.getFeature(Find.class, new DefaultFindFeature(session))).withCache(this.cache).find(r.getValue())).length(r.getKey().attributes().getSize());
                result.put(r.getKey(), move.move(r.getKey(), r.getValue(), status, new Delete.Callback(){

                    @Override
                    public void delete(Path file) {
                        MoveWorker.this.listener.message(MessageFormat.format(LocaleFactory.localizedString("Deleting {0}", "Status"), file.getName()));
                    }
                }, this.callback));
            }
        }
        return result;
    }

    protected Map<Path, Path> compile(Move move, ListService list, Path source, Path target) throws BackgroundException {
        LinkedHashMap<Path, Path> recursive = new LinkedHashMap<Path, Path>();
        if (source.isFile() || source.isSymbolicLink()) {
            recursive.put(source, target);
        } else if (source.isDirectory()) {
            if (!move.isRecursive(source, target)) {
                for (Path child : list.list(source, new WorkerListProgressListener(this, this.listener))) {
                    if (this.isCanceled()) {
                        throw new ConnectionCanceledException();
                    }
                    recursive.putAll(this.compile(move, list, child, new Path(target, child.getName(), child.getType())));
                }
            }
            recursive.put(source, target);
        }
        return recursive;
    }

    @Override
    public void cleanup(Map<Path, Path> result) {
        for (Path f : result.keySet()) {
            this.cache.invalidate(f.getParent());
        }
    }

    @Override
    public String getActivity() {
        return MessageFormat.format(LocaleFactory.localizedString("Renaming {0} to {1}", "Status"), this.files.keySet().iterator().next().getName(), this.files.values().iterator().next().getName());
    }

    @Override
    public Map<Path, Path> initialize() {
        return Collections.emptyMap();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        MoveWorker that = (MoveWorker)o;
        return !(this.files != null ? !this.files.equals(that.files) : that.files != null);
    }

    public int hashCode() {
        return this.files != null ? this.files.hashCode() : 0;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("MoveWorker{");
        sb.append("files=").append(this.files);
        sb.append('}');
        return sb.toString();
    }
}

