/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.Path;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Lock;
import ch.cyberduck.core.vault.VaultRegistry;

public class VaultRegistryLockFeature<T>
implements Lock<T> {
    private final Session<?> session;
    private final Lock<T> proxy;
    private final VaultRegistry registry;

    public VaultRegistryLockFeature(Session<?> session, Lock<T> proxy, VaultRegistry registry) {
        this.session = session;
        this.proxy = proxy;
        this.registry = registry;
    }

    @Override
    public T lock(Path file) throws BackgroundException {
        return this.registry.find(this.session, file).getFeature(this.session, Lock.class, this.proxy).lock(file);
    }

    @Override
    public void unlock(Path file, T token) throws BackgroundException {
        this.registry.find(this.session, file).getFeature(this.session, Lock.class, this.proxy).unlock(file, token);
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryLockFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

