/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.vault.registry;

import ch.cyberduck.core.Cache;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.Session;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.AttributesFinder;
import ch.cyberduck.core.vault.VaultRegistry;

public class VaultRegistryAttributesFeature
implements AttributesFinder {
    private final Session<?> session;
    private final VaultRegistry registry;
    private final AttributesFinder proxy;
    private Cache<Path> cache;

    public VaultRegistryAttributesFeature(Session<?> session, AttributesFinder proxy, VaultRegistry registry) {
        this.session = session;
        this.registry = registry;
        this.proxy = proxy;
    }

    @Override
    public PathAttributes find(Path file) throws BackgroundException {
        return this.registry.find(this.session, file).getFeature(this.session, AttributesFinder.class, this.proxy).withCache(this.cache).find(file);
    }

    @Override
    public AttributesFinder withCache(Cache<Path> cache) {
        this.cache = cache;
        return this;
    }

    public String toString() {
        StringBuilder sb = new StringBuilder("VaultRegistryAttributesFeature{");
        sb.append("proxy=").append(this.proxy);
        sb.append('}');
        return sb.toString();
    }
}

