/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.transfer;

import ch.cyberduck.core.LocaleFactory;
import ch.cyberduck.core.ProgressListener;
import ch.cyberduck.core.local.ApplicationBadgeLabeler;
import ch.cyberduck.core.local.ApplicationBadgeLabelerFactory;
import ch.cyberduck.core.notification.NotificationService;
import ch.cyberduck.core.notification.NotificationServiceFactory;
import ch.cyberduck.core.preferences.PreferencesFactory;
import ch.cyberduck.core.transfer.Transfer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import org.apache.log4j.Logger;

public final class TransferQueue {
    private static final Logger log = Logger.getLogger(TransferQueue.class);
    private final ApplicationBadgeLabeler label = ApplicationBadgeLabelerFactory.get();
    private BlockingQueue<Transfer> running;
    private final NotificationService notification = NotificationServiceFactory.get();
    private final List<Transfer> temporary = new ArrayList<Transfer>();
    private final Map<Transfer, Thread> threads = new HashMap<Transfer, Thread>();

    public TransferQueue() {
        this(PreferencesFactory.get().getInteger("queue.maxtransfers"));
    }

    public TransferQueue(int size) {
        this.running = new ArrayBlockingQueue<Transfer>(size, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void add(Transfer t, ProgressListener listener) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Add transfer %s to queue", t));
        }
        if (0 == this.running.remainingCapacity()) {
            if (log.isInfoEnabled()) {
                log.info((Object)String.format("Queuing transfer %s", t));
            }
            listener.message(LocaleFactory.localizedString("Maximum allowed connections exceeded. Waiting", "Status"));
            this.notification.notify("Transfer queued", t.getName());
        }
        try {
            this.threads.put(t, Thread.currentThread());
            this.running.put(t);
        }
        catch (InterruptedException e) {
            log.error((Object)String.format("Error waiting for slot in queue. %s", e.getMessage()));
        }
        finally {
            this.threads.remove(t);
        }
        if (log.isInfoEnabled()) {
            log.info((Object)String.format("Released from queue %s", t));
        }
        this.label.badge(String.valueOf(this.running.size()));
    }

    public void remove(Transfer t) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Remove %s from queue", t));
        }
        if (this.running.remove(t)) {
            if (0 == this.running.size()) {
                this.label.badge("");
            } else {
                this.label.badge(String.valueOf(this.running.size()));
            }
        } else {
            Thread removed = this.threads.remove(t);
            if (removed != null) {
                log.warn((Object)String.format("Interrupt thread %s for transfer %s", removed, t));
                removed.interrupt();
            }
            this.temporary.remove(t);
        }
        this.poll();
    }

    public void resize(int newsize) {
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Resize queue to %d", newsize));
        }
        int drained = this.running.drainTo(this.temporary);
        if (log.isDebugEnabled()) {
            log.debug((Object)String.format("Drained %d elements", drained));
        }
        this.running.clear();
        this.running = new ArrayBlockingQueue<Transfer>(newsize);
        this.poll();
    }

    private void poll() {
        if (log.isDebugEnabled()) {
            log.debug((Object)"Polling overflow queue");
        }
        this.temporary.removeIf(transfer -> this.running.offer((Transfer)transfer));
    }
}

