/*
 * Decompiled with CFR 0.152.
 */
package ch.cyberduck.core.shared;

import ch.cyberduck.core.DisabledConnectionCallback;
import ch.cyberduck.core.Local;
import ch.cyberduck.core.Path;
import ch.cyberduck.core.PathAttributes;
import ch.cyberduck.core.VersionId;
import ch.cyberduck.core.exception.BackgroundException;
import ch.cyberduck.core.features.Touch;
import ch.cyberduck.core.features.Upload;
import ch.cyberduck.core.features.Write;
import ch.cyberduck.core.io.BandwidthThrottle;
import ch.cyberduck.core.io.DisabledStreamListener;
import ch.cyberduck.core.local.LocalTouchFactory;
import ch.cyberduck.core.local.TemporaryFileServiceFactory;
import ch.cyberduck.core.transfer.TransferStatus;
import org.apache.log4j.Logger;

public class DefaultTouchFeature<T>
implements Touch<T> {
    private static final Logger log = Logger.getLogger(DefaultTouchFeature.class);
    private final Upload<T> feature;

    public DefaultTouchFeature(Upload<T> upload) {
        this.feature = upload;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Path touch(Path file, TransferStatus status) throws BackgroundException {
        Local temp = TemporaryFileServiceFactory.get().create(file);
        LocalTouchFactory.get().touch(temp);
        try {
            T reply = this.feature.upload(file, temp, new BandwidthThrottle(-1.0f), new DisabledStreamListener(), status, new DisabledConnectionCallback());
            if (log.isDebugEnabled()) {
                log.debug((Object)String.format("Received reply %s for creating file %s", reply, file));
            }
            if (reply instanceof VersionId) {
                Path path = new Path(file.getParent(), file.getName(), file.getType(), new PathAttributes(file.attributes()).withVersionId(((VersionId)reply).id));
                return path;
            }
        }
        finally {
            temp.delete();
        }
        return file;
    }

    @Override
    public boolean isSupported(Path workdir) {
        return true;
    }

    @Override
    public DefaultTouchFeature<T> withWriter(Write<T> writer) {
        this.feature.withWriter(writer);
        return this;
    }
}

