/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonArray;
import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.ParseException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.time.ZonedDateTime;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveCopyOperation;
import org.nuxeo.onedrive.client.OneDriveDrive;
import org.nuxeo.onedrive.client.OneDriveExpand;
import org.nuxeo.onedrive.client.OneDriveFile;
import org.nuxeo.onedrive.client.OneDriveFolder;
import org.nuxeo.onedrive.client.OneDriveIdentitySet;
import org.nuxeo.onedrive.client.OneDriveJsonRequest;
import org.nuxeo.onedrive.client.OneDriveJsonResponse;
import org.nuxeo.onedrive.client.OneDriveLongRunningAction;
import org.nuxeo.onedrive.client.OneDrivePatchOperation;
import org.nuxeo.onedrive.client.OneDrivePermission;
import org.nuxeo.onedrive.client.OneDriveRequest;
import org.nuxeo.onedrive.client.OneDriveResource;
import org.nuxeo.onedrive.client.OneDriveResponse;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;
import org.nuxeo.onedrive.client.OneDriveSharingLink;
import org.nuxeo.onedrive.client.OneDriveThumbnail;
import org.nuxeo.onedrive.client.OneDriveThumbnailSet;
import org.nuxeo.onedrive.client.OneDriveThumbnailSetIterator;
import org.nuxeo.onedrive.client.OneDriveThumbnailSize;
import org.nuxeo.onedrive.client.URLTemplate;
import org.nuxeo.onedrive.client.facets.FileSystemInfoFacet;

public abstract class OneDriveItem
extends OneDriveResource {
    OneDriveItem(OneDriveAPI api) {
        super(api);
    }

    OneDriveItem(OneDriveAPI api, OneDriveDrive drive) {
        super(api, drive);
    }

    public OneDriveItem(OneDriveAPI api, String id) {
        super(api, id);
    }

    public OneDriveItem(OneDriveAPI api, String resourceIdentifier, OneDriveResource.ResourceIdentifierType resourceIdentifierType) {
        super(api, resourceIdentifier, resourceIdentifierType);
    }

    public OneDriveItem(OneDriveAPI api, OneDriveDrive drive, String path) {
        super(api, drive, path, OneDriveResource.ResourceIdentifierType.Path);
    }

    public OneDriveItem(OneDriveAPI api, OneDriveDrive drive, String path, OneDriveResource.ResourceIdentifierType resourceIdentifierType) {
        super(api, drive, path, resourceIdentifierType);
    }

    public void delete() throws IOException {
        URL url = this.getMetadataURL().build(this.getApi().getBaseURL(), this.getResourceIdentifier());
        ((OneDriveResponse)new OneDriveRequest(url, "DELETE").sendRequest(this.getApi().getExecutor())).close();
    }

    public void patch(OneDrivePatchOperation patchOperation) throws IOException {
        URL url = this.getMetadataURL().build(this.getApi().getBaseURL(), this.getResourceIdentifier());
        new OneDriveJsonRequest(url, "PATCH", patchOperation.build()).sendRequest(this.getApi().getExecutor()).close();
    }

    public OneDriveLongRunningAction copy(OneDriveCopyOperation copyOperation) throws IOException {
        URL url = this.getCopyURL().build(this.getApi().getBaseURL(), this.getResourceIdentifier());
        OneDriveJsonResponse jsonResponse = new OneDriveJsonRequest(url, "POST", copyOperation.build()).sendRequest(this.getApi().getExecutor());
        URL locationUrl = new URL(jsonResponse.getLocation());
        return new OneDriveLongRunningAction(locationUrl, this.getApi());
    }

    protected void appendDriveResourceResolve(StringBuilder urlBuilder) {
        if (this.getResourceDrive() != null) {
            urlBuilder.append(this.getResourceDrive().getDrivePath());
        } else {
            urlBuilder.append("/drive");
        }
    }

    protected void appendItemReferenceResolve(StringBuilder urlBuilder) {
        if (this.getResourceIdentifierType() == OneDriveResource.ResourceIdentifierType.Id) {
            urlBuilder.append("/items");
        } else {
            urlBuilder.append("/root");
        }
    }

    protected void appendItemReference(StringBuilder urlBuilder) {
        if (this.isRoot()) {
            return;
        }
        if (this.getResourceIdentifierType() == OneDriveResource.ResourceIdentifierType.Path) {
            urlBuilder.append(':');
        }
        urlBuilder.append("/%1$s");
    }

    protected void appendAction(StringBuilder urlBuilder, String action) {
        if (!this.isRoot() && this.getResourceIdentifierType() == OneDriveResource.ResourceIdentifierType.Path) {
            urlBuilder.append(':');
        }
        urlBuilder.append(String.format("/%s", action));
    }

    protected void appendDriveItem(StringBuilder urlBuilder) {
        this.appendDriveResourceResolve(urlBuilder);
        this.appendItemReferenceResolve(urlBuilder);
        this.appendItemReference(urlBuilder);
    }

    protected void appendDriveItemAction(StringBuilder urlBuilder, String action) {
        this.appendDriveItem(urlBuilder);
        this.appendAction(urlBuilder, action);
    }

    public String getDrivePath() {
        StringBuilder urlBuilder = new StringBuilder();
        this.appendDriveItem(urlBuilder);
        return String.format(urlBuilder.toString(), this.getResourceIdentifier());
    }

    public URLTemplate getMetadataURL() {
        StringBuilder urlBuilder = new StringBuilder();
        this.appendDriveItem(urlBuilder);
        return new URLTemplate(urlBuilder.toString());
    }

    public URLTemplate getCopyURL() {
        StringBuilder urlBuilder = new StringBuilder();
        this.appendDriveItemAction(urlBuilder, "copy");
        return new URLTemplate(urlBuilder.toString());
    }

    public URLTemplate getSharedLinkUrl() {
        StringBuilder urlBuilder = new StringBuilder();
        this.appendDriveItemAction(urlBuilder, this.getApi().isGraphConnection() ? "createLink" : "oneDrive.createLink");
        return new URLTemplate(urlBuilder.toString());
    }

    public abstract Metadata getMetadata(OneDriveExpand ... var1) throws IOException;

    public OneDriveThumbnailSet.Metadata getThumbnailSet() throws OneDriveAPIException {
        try {
            Iterator<OneDriveThumbnailSet.Metadata> iterator = this.getThumbnailSets().iterator();
            if (iterator.hasNext()) {
                return iterator.next();
            }
        }
        catch (OneDriveRuntimeException e) {
            throw new OneDriveAPIException(e);
        }
        return null;
    }

    public OneDriveThumbnail.Metadata getThumbnail(OneDriveThumbnailSize size) throws IOException {
        return new OneDriveThumbnail(this.getApi(), this.getResourceIdentifier(), size).getMetadata();
    }

    public InputStream downloadThumbnail(OneDriveThumbnailSize size) throws IOException {
        return new OneDriveThumbnail(this.getApi(), this.getResourceIdentifier(), size).download();
    }

    Iterable<OneDriveThumbnailSet.Metadata> getThumbnailSets() {
        return () -> new OneDriveThumbnailSetIterator(this.getApi(), this.getResourceIdentifier());
    }

    public OneDrivePermission.Metadata createSharedLink(OneDriveSharingLink.Type type) throws IOException {
        URL url = this.getSharedLinkUrl().build(this.getApi().getBaseURL(), this.getResourceIdentifier());
        OneDriveJsonRequest request = new OneDriveJsonRequest(url, "POST", new JsonObject().add("type", type.getType()));
        OneDriveJsonResponse response = request.sendRequest(this.getApi().getExecutor());
        JsonObject json = response.getContent();
        String permissionId = json.asObject().get("id").asString();
        OneDrivePermission permission = this.isRoot() ? new OneDrivePermission(this.getApi(), permissionId) : new OneDrivePermission(this.getApi(), this.getResourceIdentifier(), permissionId);
        OneDrivePermission oneDrivePermission = permission;
        oneDrivePermission.getClass();
        return oneDrivePermission.new OneDrivePermission.Metadata(json);
    }

    private Metadata parseResponse(OneDriveJsonResponse response) throws IOException {
        JsonObject nextObject = response.getContent();
        String id = nextObject.get("id").asString();
        Metadata nextMetadata = null;
        if (nextObject.get("folder") != null && !nextObject.get("folder").isNull()) {
            OneDriveFolder folder;
            OneDriveFolder oneDriveFolder = folder = new OneDriveFolder(this.getApi(), id);
            oneDriveFolder.getClass();
            nextMetadata = new OneDriveFolder.Metadata(oneDriveFolder, nextObject);
        } else if (nextObject.get("file") != null && !nextObject.get("file").isNull()) {
            OneDriveFile file;
            OneDriveFile oneDriveFile = file = new OneDriveFile(this.getApi(), id);
            oneDriveFile.getClass();
            nextMetadata = oneDriveFile.new OneDriveFile.Metadata(nextObject);
        }
        return nextMetadata;
    }

    public abstract class Metadata
    extends OneDriveResource.Metadata {
        private String name;
        private String eTag;
        private OneDriveIdentitySet createdBy;
        private ZonedDateTime createdDateTime;
        private OneDriveIdentitySet lastModifiedBy;
        private ZonedDateTime lastModifiedDateTime;
        private long size;
        private OneDriveFolder.Reference parentReference;
        private String webUrl;
        private String description;
        private boolean deleted;
        private FileSystemInfoFacet fileSystemInfo;
        private List<OneDriveThumbnailSet.Metadata> thumbnailSets;

        public Metadata(JsonObject json) {
            super(json);
            this.thumbnailSets = Collections.emptyList();
        }

        public String getName() {
            return this.name;
        }

        public String getETag() {
            return this.eTag;
        }

        public OneDriveIdentitySet getCreatedBy() {
            return this.createdBy;
        }

        public ZonedDateTime getCreatedDateTime() {
            return this.createdDateTime;
        }

        public OneDriveIdentitySet getLastModifiedBy() {
            return this.lastModifiedBy;
        }

        public ZonedDateTime getLastModifiedDateTime() {
            return this.lastModifiedDateTime;
        }

        public long getSize() {
            return this.size;
        }

        public OneDriveFolder.Reference getParentReference() {
            return this.parentReference;
        }

        public String getWebUrl() {
            return this.webUrl;
        }

        public String getDescription() {
            return this.description;
        }

        public boolean isDeleted() {
            return this.deleted;
        }

        public FileSystemInfoFacet getFileSystemInfo() {
            return this.fileSystemInfo;
        }

        public OneDriveThumbnailSet.Metadata getThumbnailSet() {
            return this.thumbnailSets.stream().findFirst().orElse(null);
        }

        List<OneDriveThumbnailSet.Metadata> getThumbnailSets() {
            return Collections.unmodifiableList(this.thumbnailSets);
        }

        @Override
        protected void parseMember(JsonObject.Member member) {
            super.parseMember(member);
            try {
                JsonValue value = member.getValue();
                String memberName = member.getName();
                if ("name".equals(memberName)) {
                    this.name = value.asString();
                } else if ("eTag".equals(memberName)) {
                    this.eTag = value.asString();
                } else if ("createdBy".equals(memberName)) {
                    this.createdBy = new OneDriveIdentitySet(value.asObject());
                } else if ("createdDateTime".equals(memberName)) {
                    this.createdDateTime = ZonedDateTime.parse(value.asString());
                } else if ("lastModifiedBy".equals(memberName)) {
                    this.lastModifiedBy = new OneDriveIdentitySet(value.asObject());
                } else if ("lastModifiedDateTime".equals(memberName)) {
                    this.lastModifiedDateTime = ZonedDateTime.parse(value.asString());
                } else if ("size".equals(memberName)) {
                    this.size = value.asLong();
                } else if ("parentReference".equals(memberName)) {
                    JsonObject valueObject = value.asObject();
                    if (valueObject.names().contains("id")) {
                        OneDriveFolder parentFolder;
                        String id = valueObject.get("id").asString();
                        OneDriveFolder oneDriveFolder = parentFolder = new OneDriveFolder(OneDriveItem.this.getApi(), id);
                        oneDriveFolder.getClass();
                        this.parentReference = new OneDriveFolder.Reference(oneDriveFolder, valueObject);
                    } else if (valueObject.names().contains("driveId")) {
                        OneDriveFolder parentFolder;
                        String driveId = valueObject.get("driveId").asString();
                        OneDriveFolder oneDriveFolder = parentFolder = new OneDriveFolder(OneDriveItem.this.getApi(), driveId);
                        oneDriveFolder.getClass();
                        this.parentReference = new OneDriveFolder.Reference(oneDriveFolder, valueObject);
                    }
                } else if ("fileSystemInfo".equals(memberName)) {
                    this.fileSystemInfo = new FileSystemInfoFacet();
                    this.fileSystemInfo.fromJson(value.asObject());
                } else if ("webUrl".equals(memberName)) {
                    this.webUrl = value.asString();
                } else if ("description".equals(memberName)) {
                    this.description = value.asString();
                } else if ("deleted".equals(memberName)) {
                    this.deleted = true;
                } else if ("thumbnailSets".equals(memberName)) {
                    this.parseThumbnailsMember(value.asArray());
                }
            }
            catch (ParseException e) {
                throw new OneDriveRuntimeException(new OneDriveAPIException(e.getMessage(), e));
            }
        }

        private void parseThumbnailsMember(JsonArray thumbnails) {
            this.thumbnailSets = new ArrayList<OneDriveThumbnailSet.Metadata>(thumbnails.size());
            for (JsonValue value : thumbnails) {
                OneDriveThumbnailSet thumbnailSet;
                JsonObject thumbnail = value.asObject();
                int id = Integer.parseInt(thumbnail.get("id").asString());
                OneDriveThumbnailSet oneDriveThumbnailSet = thumbnailSet = new OneDriveThumbnailSet(OneDriveItem.this.getApi(), this.getId(), id);
                oneDriveThumbnailSet.getClass();
                this.thumbnailSets.add(new OneDriveThumbnailSet.Metadata(oneDriveThumbnailSet, thumbnail));
            }
        }

        public boolean isFolder() {
            return false;
        }

        public boolean isFile() {
            return false;
        }

        public OneDriveFolder.Metadata asFolder() {
            throw new UnsupportedOperationException("Not a folder.");
        }

        public OneDriveFile.Metadata asFile() {
            throw new UnsupportedOperationException("Not a file.");
        }
    }
}

