/*
 * Decompiled with CFR 0.152.
 */
package org.nuxeo.onedrive.client;

import com.eclipsesource.json.JsonObject;
import com.eclipsesource.json.JsonValue;
import com.eclipsesource.json.ParseException;
import java.io.IOException;
import java.net.URL;
import java.util.Iterator;
import org.nuxeo.onedrive.client.OneDriveAPI;
import org.nuxeo.onedrive.client.OneDriveAPIException;
import org.nuxeo.onedrive.client.OneDriveExpand;
import org.nuxeo.onedrive.client.OneDriveFolder;
import org.nuxeo.onedrive.client.OneDriveItem;
import org.nuxeo.onedrive.client.OneDriveJsonRequest;
import org.nuxeo.onedrive.client.OneDriveJsonResponse;
import org.nuxeo.onedrive.client.OneDriveResource;
import org.nuxeo.onedrive.client.OneDriveRuntimeException;
import org.nuxeo.onedrive.client.QueryStringBuilder;
import org.nuxeo.onedrive.client.URLTemplate;

public class OneDriveDrive
extends OneDriveResource
implements Iterable<OneDriveItem.Metadata> {
    private OneDriveDrive(OneDriveAPI api) {
        super(api);
    }

    public OneDriveDrive(OneDriveAPI api, String id) {
        super(api, id);
    }

    public static OneDriveDrive getDefaultDrive(OneDriveAPI api) {
        return new OneDriveDrive(api);
    }

    public Metadata getMetadata(OneDriveExpand ... expands) throws IOException {
        QueryStringBuilder query = new QueryStringBuilder().set("expand", expands);
        URL url = this.getMetadataUrl().build(this.getApi().getBaseURL(), query, this.getResourceIdentifier());
        OneDriveJsonRequest request = new OneDriveJsonRequest(url, "GET");
        OneDriveJsonResponse response = request.sendRequest(this.getApi().getExecutor());
        JsonObject jsonObject = response.getContent();
        response.close();
        return new Metadata(jsonObject);
    }

    public URLTemplate getMetadataUrl() {
        return new URLTemplate(this.getDrivePath());
    }

    public String getDrivePath() {
        if (this.isRoot()) {
            return "/drive";
        }
        return String.format("/drives/%s", this.getResourceIdentifier());
    }

    public OneDriveFolder getRoot() {
        return new OneDriveFolder(this.getApi(), this);
    }

    @Override
    public Iterator<OneDriveItem.Metadata> iterator() {
        return this.iterator();
    }

    public Iterator<OneDriveItem.Metadata> iterator(OneDriveExpand ... expands) {
        return this.getRoot().iterator(expands);
    }

    public static enum DriveType {
        unknown,
        personal,
        business,
        documentLibrary;

    }

    public class Metadata
    extends OneDriveResource.Metadata {
        private Long total;
        private Long used;
        private Long remaining;
        private String id;
        private DriveType driveType;

        public Metadata(JsonObject json) {
            super(OneDriveDrive.this, json);
        }

        @Override
        public OneDriveResource getResource() {
            return OneDriveDrive.this;
        }

        @Override
        protected void parseMember(JsonObject.Member member) {
            super.parseMember(member);
            try {
                JsonValue value = member.getValue();
                String memberName = member.getName();
                if ("id".equals(memberName)) {
                    this.id = value.asString();
                } else if ("driveType".equals(memberName)) {
                    try {
                        this.driveType = DriveType.valueOf(value.asString());
                    }
                    catch (IllegalArgumentException e) {
                        this.driveType = DriveType.unknown;
                    }
                } else if ("quota".equals(memberName)) {
                    Metadata.parseMember(value.asObject(), this::parseQuotaMember);
                }
            }
            catch (ParseException e) {
                throw new OneDriveRuntimeException(new OneDriveAPIException(e.getMessage(), e));
            }
        }

        private void parseQuotaMember(JsonObject.Member member) {
            JsonValue value = member.getValue();
            String memberName = member.getName();
            if ("total".equals(memberName)) {
                this.total = value.asLong();
            } else if ("used".equals(memberName)) {
                this.used = value.asLong();
            } else if ("remaining".equals(memberName)) {
                this.remaining = value.asLong();
            }
        }

        public Long getTotal() {
            return this.total;
        }

        public Long getUsed() {
            return this.used;
        }

        public Long getRemaining() {
            return this.remaining;
        }

        public DriveType getDriveType() {
            return this.driveType;
        }

        @Override
        public String getId() {
            return this.id;
        }
    }
}

